/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.WildcardQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseWildcardQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testWildcardQuery() {
        for (int i = 0; i < 10; ++i) {
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "SomeUser" + i));
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "OtherUser" + i));
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "Other" + i));
        }
        this.assertSearch(indexingTestHelper -> {
            WildcardQuery wildcardQuery = this.queries.wildcard("userName", "Oth*ser*");
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames("_all");
            searchSearchRequest.setQuery(wildcardQuery);
            searchSearchRequest.setSize(20);
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = searchEngineAdapter.execute(searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals("Total hits", 10L, searchHits.getTotalHits());
            List<SearchHit> searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals("Retrieved hits", 10L, searchHitsList.size());
            searchHitsList.forEach(searchHit -> {
                Document document = searchHit.getDocument();
                String userName = document.getString("userName");
                Assert.assertTrue(userName.startsWith("OtherUser"));
            });
        });
    }
}

