/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.TermQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseTermQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testTermQuery() {
        this.addDocument(document -> {
            document.addKeyword("uid", 1);
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("uid", 2);
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("uid", 3);
            document.addKeyword("userName", "SomeUser3");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("uid", 4);
            document.addKeyword("userName", "SomeUser4");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("uid", 5);
            document.addKeyword("userName", "SomeUser5");
            document.addNumber("priority", 1);
        });
        this.assertSearch(indexingTestHelper -> {
            TermQuery termQuery = this.queries.term("userName", "SomeUser5");
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames("_all");
            searchSearchRequest.setQuery(termQuery);
            searchSearchRequest.setSize(30);
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = searchEngineAdapter.execute(searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals("Total hits", 1L, searchHits.getTotalHits());
            List<SearchHit> searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals("Retrieved hits", 1L, searchHitsList.size());
            SearchHit searchHit = searchHitsList.get(0);
            Document document = searchHit.getDocument();
            Assert.assertEquals("SomeUser5", document.getString("userName"));
        });
    }
}

