/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.PrefixQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BasePrefixQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testPrefixQuery() {
        for (int i = 0; i < 10; ++i) {
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "SomeUser" + i));
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "OtherUser" + i));
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "Other" + i));
        }
        final PrefixQuery prefixQuery = this.queries.prefix("userName", "Oth");
        this.assertSearch(indexingTestHelper -> {
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = searchEngineAdapter.execute(new SearchSearchRequest(){
                {
                    this.addSorts(BasePrefixQueryTestCase.this.sorts.field("userName"));
                    this.setIndexNames("_all");
                    this.setQuery(prefixQuery);
                    this.setSize(30);
                }
            });
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals("Total hits", 20L, searchHits.getTotalHits());
            List<SearchHit> searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals("Retrieved hits", 20L, searchHitsList.size());
            searchHitsList.forEach(searchHit -> {
                Document document = searchHit.getDocument();
                String userName = document.getString("userName");
                Assert.assertTrue(userName.startsWith("Oth"));
            });
        });
    }
}

