/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.MatchQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseMatchQueryTestCase
extends BaseIndexingTestCase {
    private static final String _FIELD_NAME = "content";

    @Test
    public void testMatchQuery() {
        this.addDocuments("java eclipse", "java liferay", "java liferay eclipse", "C is the best language");
        this.assertSearch("liferay uses java", Arrays.asList("java liferay", "java liferay eclipse", "java eclipse"));
    }

    protected void addDocuments(String ... values) {
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(_FIELD_NAME, value), Arrays.asList(values));
    }

    protected void assertSearch(Object value, List<String> expectedValues) {
        this.assertSearch(indexingTestHelper -> {
            MatchQuery matchQuery = this.queries.match(_FIELD_NAME, value);
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames("_all");
            searchSearchRequest.setQuery(matchQuery);
            searchSearchRequest.setSize(30);
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = searchEngineAdapter.execute(searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals("Total hits", expectedValues.size(), searchHits.getTotalHits());
            List<SearchHit> searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals("Retrieved hits", expectedValues.size(), searchHitsList.size());
            ArrayList actualValues = new ArrayList();
            searchHitsList.forEach(searchHit -> {
                Document document = searchHit.getDocument();
                actualValues.add(document.getString(_FIELD_NAME));
            });
            Assert.assertEquals("Retrieved hits ->" + actualValues, expectedValues.toString(), ((Object)actualValues).toString());
        });
    }
}

