/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.MatchAllQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseMatchAllQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testMatchAllQuery() {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        final MatchAllQuery matchAllQuery = this.queries.matchAll();
        this.assertSearch(indexingTestHelper -> {
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = searchEngineAdapter.execute(new SearchSearchRequest(){
                {
                    this.addSorts(BaseMatchAllQueryTestCase.this.sorts.field("priority"));
                    this.setIndexNames("_all");
                    this.setQuery(matchAllQuery);
                    this.setSize(30);
                }
            });
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals("Total hits", 20L, searchHits.getTotalHits());
            List<SearchHit> searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals("Retrieved hits", 20L, searchHitsList.size());
            for (int i = 0; i < 20; ++i) {
                SearchHit searchHit = searchHitsList.get(i);
                Document document = searchHit.getDocument();
                Double priority = document.getDouble("priority");
                Assert.assertEquals("Priority value", (double)i + 1.0, priority, 0.0);
            }
        });
    }

    @Test
    public void testMatchAllQueryWithSize0() {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        this.assertSearch(indexingTestHelper -> {
            MatchAllQuery matchAllQuery = this.queries.matchAll();
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames("_all");
            searchSearchRequest.setQuery(matchAllQuery);
            searchSearchRequest.setSize(0);
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = searchEngineAdapter.execute(searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals("Total hits", 20L, searchHits.getTotalHits());
            List<SearchHit> searchHitsList = searchHits.getSearchHits();
            Assert.assertTrue("Expected empty search hits", searchHitsList.isEmpty());
        });
    }
}

