/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.IdsQuery;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Test;

public abstract class BaseIdsQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testIdsQuery() {
        this.index(1, "alpha");
        this.index(2, "bravo");
        this.index(3, "charlie");
        this.index(4, "delta");
        final IdsQuery idsQuery = this.queries.ids();
        idsQuery.addIds("1", "4");
        final FieldSort sort = this.sorts.field("userName", SortOrder.DESC);
        String expected = "[delta, alpha]";
        this.assertSearch(indexingTestHelper -> {
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = searchEngineAdapter.execute(new SearchSearchRequest(){
                {
                    this.addSorts(sort);
                    this.setIndexNames("_all");
                    this.setQuery(idsQuery);
                }
            });
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Stream<Document> stream = this.getDocumentsStream(searchHits);
            DocumentsAssert.assertValues(searchSearchResponse.getSearchRequestString(), stream, "userName", expected);
        });
    }

    protected Stream<Document> getDocumentsStream(SearchHits searchHits) {
        List<SearchHit> list = searchHits.getSearchHits();
        Stream stream = list.stream();
        return stream.map(SearchHit::getDocument);
    }

    protected void index(int uid, String userName) {
        this.addDocument(document -> {
            document.addKeyword("uid", uid);
            document.addKeyword("userName", userName);
        });
    }
}

