/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.ExistsQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseExistsQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testExistsQuery() {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 1);
        });
        this.assertSearch(indexingTestHelper -> {
            ExistsQuery existsQuery = this.queries.exists("userName");
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames("_all");
            searchSearchRequest.setQuery(existsQuery);
            searchSearchRequest.setSize(30);
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = searchEngineAdapter.execute(searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals("Total hits", 1L, searchHits.getTotalHits());
            List<SearchHit> searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals("Retrieved hits", 1L, searchHitsList.size());
            SearchHit searchHit = searchHitsList.get(0);
            Document document = searchHit.getDocument();
            Assert.assertEquals("Priority value", 1.0, document.getDouble("priority"), 0.0);
            Assert.assertEquals("SomeUser1", document.getString("userName"));
        });
    }
}

