/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.DateRangeTermQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseDateRangeTermQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testDateRangeTermQuery() {
        this.addDocument(this.getDate("2016-02-01T00:00:00"));
        this.addDocument(this.getDate("2016-02-02T00:00:00"));
        this.addDocument(this.getDate("2017-02-02T00:00:00"));
        this.addDocument(this.getDate("2017-02-03T00:00:00"));
        this.addDocument(this.getDate("2018-02-03T00:00:00"));
        this.addDocument(this.getDate("2018-02-03T00:00:00"));
        this.addDocument(this.getDate("2019-02-05T00:00:00"));
        final DateRangeTermQuery dateRangeTermQuery = this.queries.dateRangeTerm("expirationDate", true, true, "20170101", "20181231");
        dateRangeTermQuery.setDateFormat("yyyyMMdd");
        this.assertSearch(indexingTestHelper -> {
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = searchEngineAdapter.execute(new SearchSearchRequest(){
                {
                    this.addSorts(BaseDateRangeTermQueryTestCase.this.sorts.field("expirationDate"));
                    this.setIndexNames("_all");
                    this.setQuery(dateRangeTermQuery);
                }
            });
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals("Total hits", 4L, searchHits.getTotalHits());
            List<SearchHit> searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals("Retrieved hits", 4L, searchHitsList.size());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            searchHitsList.forEach(searchHit -> {
                Document document = searchHit.getDocument();
                String expirationDateString = document.getDate("expirationDate");
                try {
                    Date expirationDate = dateFormat.parse(expirationDateString);
                    Assert.assertTrue(expirationDate.after(this.getDate("2016-12-31T23:59:59")));
                    Assert.assertTrue(expirationDate.before(this.getDate("2018-12-31T23:59:59")));
                }
                catch (ParseException pe) {
                    Assert.fail(StackTraceUtil.getStackTrace(pe));
                }
            });
        });
    }

    protected void addDocument(Date date) {
        this.addDocument(DocumentCreationHelpers.singleDate("expirationDate", date));
    }

    protected Date getDate(String date) {
        LocalDateTime localDateTime = LocalDateTime.parse(date);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }
}

