/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.search.analysis.FieldQueryBuilder;
import com.liferay.portal.search.internal.analysis.SimpleKeywordTokenizer;
import com.liferay.portal.search.internal.analysis.TitleFieldQueryBuilder;
import com.liferay.portal.search.test.util.mappings.BaseFieldQueryBuilderTestCase;
import java.util.Arrays;
import org.junit.Test;

public abstract class BaseTitleFieldQueryBuilderTestCase
extends BaseFieldQueryBuilderTestCase {
    @Test
    public void testBasicWordMatches() throws Exception {
        this.addDocument("name tag end");
        this.addDocument("NA-META-G");
        this.addDocument("Tag Name");
        this.addDocument("TAG1");
        this.assertSearch("end", Arrays.asList("name tag end"));
        this.assertSearch("g", Arrays.asList("NA-META-G"));
        this.assertSearch("META G", Arrays.asList("NA-META-G"));
        this.assertSearch("meta", Arrays.asList("NA-META-G"));
        this.assertSearch("META-G", Arrays.asList("NA-META-G"));
        this.assertSearch("nA mEtA g", Arrays.asList("NA-META-G"));
        this.assertSearch("NA-META-G", Arrays.asList("NA-META-G"));
        this.assertSearch("na-meta-g", Arrays.asList("NA-META-G"));
        this.assertSearch("name tag", Arrays.asList("name tag end", "Tag Name"));
        this.assertSearch("name", Arrays.asList("Tag Name", "name tag end"));
        this.assertSearch("NaMe*", Arrays.asList("Tag Name", "name tag end"));
        this.assertSearch("name-tag", Arrays.asList("name tag end", "Tag Name"));
        this.assertSearch("tag 1", Arrays.asList("Tag Name", "name tag end"));
        this.assertSearch("tag name", Arrays.asList("Tag Name", "name tag end"));
        this.assertSearch("tag", Arrays.asList("Tag Name", "name tag end", "TAG1"));
        this.assertSearch("tag(142857)", Arrays.asList("Tag Name", "name tag end"));
        this.assertSearch("tag1", Arrays.asList("TAG1"));
        this.assertSearchNoHits("1");
        this.assertSearchNoHits("ame");
        this.assertSearchNoHits("METAG");
        this.assertSearchNoHits("nameTAG");
        this.assertSearchNoHits("tag2");
    }

    @Test
    public void testDot() throws Exception {
        this.addDocument("1.0");
        this.addDocument("1.1");
        this.assertSearch("1.0", Arrays.asList("1.0"));
        this.assertSearch("1.1", Arrays.asList("1.1"));
        this.assertSearch("1", Arrays.asList("1.0", "1.1"));
        this.assertSearchNoHits("0");
    }

    @Test
    public void testExactMatchBoost() throws Exception {
        this.addDocument("one two three four five six seven eight");
        this.addDocument("one two three four five six");
        this.addDocument("three four five six seven");
        this.addDocument("one two four five seven eight");
        this.assertSearch("one two four five seven eight", Arrays.asList("one two four five seven eight", "one two three four five six seven eight", "one two three four five six", "three four five six seven"));
        this.assertSearch("three four five six seven", Arrays.asList("three four five six seven", "one two three four five six seven eight", "one two three four five six", "one two four five seven eight"));
        this.assertSearch("\"one two\" \"three four\" \"five six\"", Arrays.asList("one two three four five six", "one two three four five six seven eight"));
        this.assertSearch("\"three four\" five \"six seven\"", Arrays.asList("three four five six seven", "one two three four five six seven eight"));
    }

    @Test
    public void testLuceneUnfriendlyTerms() throws Exception {
        this.assertSearchNoHits("*");
        this.assertSearchNoHits("&");
        this.assertSearchNoHits("-");
        this.assertSearchNoHits("!");
        this.assertSearchNoHits(")");
        this.assertSearchNoHits("(");
        this.assertSearchNoHits("]");
        this.assertSearchNoHits("[");
        this.assertSearchNoHits("}");
        this.assertSearchNoHits("{");
        this.assertSearchNoHits("\\");
        this.assertSearchNoHits("* &- !");
        this.assertSearchNoHits("AND");
        this.assertSearchNoHits("NOT");
        this.assertSearchNoHits("OR");
        this.assertSearchNoHits("ONE AND TWO OR THREE NOT FOUR");
        this.assertSearchNoHits("\"ONE\" NOT \"TWO\"");
    }

    @Test
    public void testMultiwordPrefixes() throws Exception {
        this.addDocument("Name Tags");
        this.addDocument("Names Tab");
        this.addDocument("Tag Names");
        this.addDocument("Tabs Names Tags");
        this.assertSearch("name ta", 1);
        this.assertSearch("name tab", 2);
        this.assertSearch("name tabs", 2);
        this.assertSearch("name tag", 2);
        this.assertSearch("name tags", 2);
        this.assertSearch("names ta", 3);
        this.assertSearch("names tab", 3);
        this.assertSearch("names tabs", 3);
        this.assertSearch("names tag", 3);
        this.assertSearch("names tags", 4);
        this.assertSearch("tab na", 1);
        this.assertSearch("tab names", 3);
        this.assertSearch("tabs na ta", 1);
        this.assertSearch("tabs names tags", 4);
        this.assertSearch("tabs names", 3);
        this.assertSearch("tag na", 1);
        this.assertSearch("tag name", 2);
        this.assertSearch("tag names", 3);
        this.assertSearch("tags na ta", 2);
        this.assertSearch("tags names tabs", 4);
        this.assertSearch("tags names", 4);
        this.assertSearch("zz name", 1);
        this.assertSearch("zz names", 3);
        this.assertSearch("zz tab", 1);
        this.assertSearch("zz tabs", 1);
        this.assertSearch("zz tag", 1);
        this.assertSearch("zz tags", 2);
        this.assertSearchNoHits("zz na");
        this.assertSearchNoHits("zz ta");
    }

    @Test
    public void testNull() throws Exception {
        this.addDocument("null");
        this.addDocument("anulled");
        this.addDocument("The word null is in this sentence");
        this.addDocument("Ultimate Nullifier");
        this.addDocument("llun");
        this.assertSearch("null", Arrays.asList("null", "The word null is in this sentence", "Ultimate Nullifier"));
    }

    @Test
    public void testNumbers() throws Exception {
        this.addDocument("Nametag5");
        this.addDocument("2Tagname");
        this.addDocument("LETTERS ONLY");
        this.assertSearch("2", 1);
        this.assertSearch("2Tag", 1);
        this.assertSearch("2Tagname", 1);
        this.assertSearch("Name", 1);
        this.assertSearch("Nametag", 1);
        this.assertSearch("Nametag5", 1);
        this.assertSearchNoHits("5");
        this.assertSearchNoHits("5Nametag");
        this.assertSearchNoHits("5Tagname");
        this.assertSearchNoHits("Nametag2");
        this.assertSearchNoHits("Nametag9");
        this.assertSearchNoHits("Tagname");
        this.assertSearchNoHits("Tagname5");
        this.assertSearchNoHits("Tagname2");
        this.assertSearchNoHits("Tagname9");
    }

    @Test
    public void testPhrasePrefixes() throws Exception {
        this.addDocument("Nametag");
        this.addDocument("NA-META-G");
        this.addDocument("Tag Name");
        this.addDocument("TAG1");
        this.assertSearch("\"me*\"", 1);
        this.assertSearch("\"meta\"", 1);
        this.assertSearch("\"na, meta, g\"", 1);
        this.assertSearch("\"namet*\"", 1);
        this.assertSearch("\"Ta*\"", 2);
        this.assertSearch("\"Tag (Name)\"", 1);
        this.assertSearch("\"tag1\"", 1);
        this.assertSearch("\"tag\"", 1);
        this.assertSearch("\"*me*\"", 1);
        this.assertSearch("\"*met*\"", 1);
        this.assertSearch("\"*namet*\"", 1);
        this.assertSearch("\"*Ta*\"", 2);
        this.assertSearchNoHits("\"met\"");
        this.assertSearchNoHits("\"NA G\"");
        this.assertSearchNoHits("\"Namet\"");
        this.assertSearchNoHits("\"Ta\"");
        this.assertSearchNoHits("\"tag 1\"");
        this.assertSearchNoHits("\"*me\"");
        this.assertSearchNoHits("\"*namet\"");
        this.assertSearchNoHits("\"*Ta\"");
    }

    @Test
    public void testPhrases() throws Exception {
        this.addDocument("Names of Tags");
        this.addDocument("More names of tags here");
        this.assertSearch("\"HERE\"", 1);
        this.assertSearch("\"more\"   names   \"here\"", 1);
        this.assertSearch("\"More\"", 1);
        this.assertSearch("\"more\"", 1);
        this.assertSearch("\"names of tags\"", 2);
        this.assertSearch("\"NAmes\" \"TAGS\"", 2);
        this.assertSearch("\"names\" MORE \"tags\"", 1);
        this.assertSearch("\"names\" of \"tAgs\"", 2);
        this.assertSearch("\"Tags here\"", 1);
        this.assertSearch("\"Tags\" here", 1);
        this.assertSearch("\"TAGS\"", 2);
        this.assertSearch("\"   more   \"   tags   \"   here   \"", 1);
        this.assertSearchNoHits("\"more\" other \"here\"");
        this.assertSearchNoHits("\"name\" of \"tags\"");
    }

    @Test
    public void testStopwords() throws Exception {
        this.addDocument("Names of Tags");
        this.addDocument("More names of tags");
        this.assertSearch("of", 2);
        this.assertSearch("Names of tags", 2);
        this.assertSearch("tags names", 2);
    }

    @Test
    public void testWhitespace() throws Exception {
        String ideographicSpace = "\u3000";
        this.assertSearchNoHits(ideographicSpace);
        this.assertSearchNoHits("ONE" + ideographicSpace + "TWO");
        this.assertSearchNoHits("\"ONE\"" + ideographicSpace + "\"TWO\"");
    }

    @Test
    public void testWildcardCharacters() throws Exception {
        this.addDocument("AAA+BBB-CCC{DDD]");
        this.addDocument("AAA BBB CCC DDD");
        this.addDocument("M*A*S*H");
        this.addDocument("M... A... S... H");
        this.addDocument("Who? When? Where?");
        this.addDocument("Who. When. Where.");
        this.assertSearch("AAA+???-CCC?DDD]", Arrays.asList("AAA+BBB-CCC{DDD]", "AAA BBB CCC DDD"));
        this.assertSearch("AAA+*{DDD*", Arrays.asList("AAA+BBB-CCC{DDD]", "AAA BBB CCC DDD"));
        this.assertSearch("AA?+BB?-CC?{DD?]", Arrays.asList(new String[0]));
        this.assertSearch("AA*+BB*-CC*{DD*]", Arrays.asList(new String[0]));
        this.assertSearch("M*A*S*H", Arrays.asList("M*A*S*H", "M... A... S... H"));
        this.assertSearch("M A S H", Arrays.asList("M*A*S*H", "M... A... S... H"));
        this.assertSearch("M* A* *S *H", Arrays.asList("M*A*S*H", "M... A... S... H"));
        this.assertSearch("When?", Arrays.asList("Who? When? Where?", "Who. When. Where."));
        this.assertSearch("Who? When?", Arrays.asList("Who? When? Where?", "Who. When. Where."));
        this.assertSearch("Who? *en? Where?", Arrays.asList("Who? When? Where?", "Who. When. Where."));
        this.assertSearch("Who? * Where?", Arrays.asList("Who? When? Where?", "Who. When. Where."));
        this.assertSearch("Who?   When?   Where?", Arrays.asList("Who? When? Where?", "Who. When. Where."));
        this.assertSearch("Wh?? W?en? Wher??", Arrays.asList(new String[0]));
        this.assertSearch("Wh* W*en* Wher*", Arrays.asList(new String[0]));
    }

    @Test
    public void testWordPrefixes() throws Exception {
        this.addDocument("Nametag");
        this.addDocument("NA-META-G");
        this.addDocument("Tag Name");
        this.addDocument("TAG1");
        this.assertSearch("me", 1);
        this.assertSearch("me*", 1);
        this.assertSearch("met", 1);
        this.assertSearch("Na", 3);
        this.assertSearch("NA*", 3);
        this.assertSearch("Namet", 1);
        this.assertSearch("namet*", 1);
        this.assertSearch("Ta", 2);
        this.assertSearch("Ta*", 2);
        this.assertSearch("tag", 2);
        this.assertSearch("*me", 1);
        this.assertSearch("*me*", 1);
        this.assertSearch("*met*", 1);
        this.assertSearch("*NA", 3);
        this.assertSearch("*NA*", 3);
        this.assertSearch("*namet", 1);
        this.assertSearch("*namet*", 1);
        this.assertSearch("*Ta", 2);
        this.assertSearch("*Ta*", 2);
        this.assertSearchNoHits("ag");
        this.assertSearchNoHits("amet");
    }

    @Override
    protected FieldQueryBuilder createFieldQueryBuilder() {
        return new TitleFieldQueryBuilder(){
            {
                this.keywordTokenizer = new SimpleKeywordTokenizer();
            }
        };
    }

    @Override
    protected String getField() {
        return "title";
    }
}

