/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.analysis.FieldQueryBuilder;
import com.liferay.portal.search.internal.analysis.SimpleKeywordTokenizer;
import com.liferay.portal.search.internal.analysis.TitleFieldQueryBuilder;
import com.liferay.portal.search.test.util.mappings.BaseFieldQueryBuilderTestCase;
import java.util.HashMap;
import org.junit.Test;

public abstract class BaseMaxExpansionsTestCase
extends BaseFieldQueryBuilderTestCase {
    private static final int _MAX_EXPANSIONS = 60;
    private static final int _TOTAL_DOCUMENTS = 65;

    @Test
    public void testPrefixWithDashNumberSuffix() throws Exception {
        this.addDocuments("Prefix-#");
        this.assertSearch("Prefi", 65);
        this.assertSearchCount("Prefi", 65);
    }

    @Test
    public void testPrefixWithDotNumberSuffix() throws Exception {
        this.addDocuments("Prefix.#");
        this.assertSearch("Prefi", 65);
        this.assertSearchCount("Prefi", 65);
    }

    @Test
    public void testPrefixWithNoSuffix() throws Exception {
        this.addDocuments("Prefix");
        this.assertSearch("Prefi", 65);
        this.assertSearchCount("Prefi", 65);
    }

    @Test
    public void testPrefixWithNumberSpaceNumberSuffix() throws Exception {
        this.addDocuments("Prefix# #");
        this.assertSearch("Prefi", 60);
        this.assertSearchCount("Prefi", 60);
    }

    @Test
    public void testPrefixWithNumberSuffix() throws Exception {
        this.addDocuments("Prefix#");
        this.assertSearch("Prefi", 60);
        this.assertSearchCount("Prefi", 60);
    }

    @Test
    public void testPrefixWithSpaceNumberSuffix() throws Exception {
        this.addDocuments("Prefix #");
        this.assertSearch("Prefi", 65);
        this.assertSearchCount("Prefi", 65);
    }

    @Test
    public void testPrefixWithUnderscoreNumberSuffix() throws Exception {
        this.addDocuments("Prefix_#");
        this.assertSearch("Prefi", 60);
        this.assertSearchCount("Prefi", 60);
    }

    protected void addDocuments(String pattern) throws Exception {
        for (int i = 1; i <= 65; ++i) {
            this.addDocument(StringUtil.replace(pattern, '#', String.valueOf(i)));
        }
    }

    @Override
    protected FieldQueryBuilder createFieldQueryBuilder() {
        return new TitleFieldQueryBuilder(){
            {
                this.keywordTokenizer = new SimpleKeywordTokenizer();
                HashMap<String, Integer> properties = new HashMap<String, Integer>();
                properties.put("maxExpansions", 60);
                this.activate(properties);
            }
        };
    }

    @Override
    protected String getField() {
        return "title";
    }
}

