/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.search.test.util.document.BaseDocumentTestCase;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseDocumentMappingTestCase
extends BaseDocumentTestCase {
    @Test
    public void testFirstNamesSearchResults() throws Exception {
        Stream<String> stream = this.getScreenNamesStream();
        stream.forEach(this::assertMappings);
    }

    @Test
    public void testLastNameSearchResults() throws Exception {
        this.assertMappings("Smith");
    }

    protected void assertMappings(Document document) {
        String screenName = document.get("screenName");
        Assert.assertEquals(Double.valueOf(document.get("sd")), (double)((Double)this.doubles.get(screenName)), 0.0);
        Assert.assertEquals(Long.valueOf(document.get("sl")).longValue(), (float)((Long)this.longs.get(screenName)).longValue(), 0.0f);
        Assert.assertEquals(Float.valueOf(document.get("sf")).floatValue(), ((Float)this.floats.get(screenName)).floatValue(), 0.0f);
        Assert.assertEquals(Integer.valueOf(document.get("si")).intValue(), (float)((Integer)this.integers.get(screenName)).intValue(), 0.0f);
        Assert.assertArrayEquals(this.getDoubleArray(document), (Object[])this.doubleArrays.get(screenName));
        Assert.assertArrayEquals((Object[])this.getLongArray(document), (Object[])this.longArrays.get(screenName));
        Assert.assertArrayEquals(this.getFloatArray(document), (Object[])this.floatArrays.get(screenName));
        Assert.assertArrayEquals((Object[])this.getIntegerArray(document), (Object[])this.integerArrays.get(screenName));
    }

    protected void assertMappings(String keywords) {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.setQuery(this.getQuery(keywords));
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> {
                for (Document document : hits.getDocs()) {
                    this.assertMappings(document);
                }
            });
        });
    }

    protected Double[] getDoubleArray(Document document) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (String value : document.getValues("md")) {
            list.add(Double.valueOf(value));
        }
        return list.toArray(new Double[0]);
    }

    protected Float[] getFloatArray(Document document) {
        ArrayList<Float> list = new ArrayList<Float>();
        for (String value : document.getValues("mf")) {
            list.add(Float.valueOf(value));
        }
        return list.toArray(new Float[0]);
    }

    protected Integer[] getIntegerArray(Document document) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String value : document.getValues("mi")) {
            list.add(Integer.valueOf(value));
        }
        return list.toArray(new Integer[0]);
    }

    protected Long[] getLongArray(Document document) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (String value : document.getValues("ml")) {
            list.add(Long.valueOf(value));
        }
        return list.toArray(new Long[0]);
    }

    protected Query getQuery(String keywords) {
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        booleanQueryImpl.add((Query)new MatchQuery("firstName", keywords), BooleanClauseOccur.SHOULD);
        booleanQueryImpl.add((Query)new MatchQuery("lastName", keywords), BooleanClauseOccur.SHOULD);
        return booleanQueryImpl;
    }
}

