/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.search.test.util.mappings.BaseTitleFieldQueryBuilderTestCase;
import com.liferay.portal.util.LocalizationImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.junit.Test;

public abstract class BaseAssetTagNamesFieldQueryBuilderTestCase
extends BaseTitleFieldQueryBuilderTestCase {
    private static final String _FIELD = BaseAssetTagNamesFieldQueryBuilderTestCase._getLocalizedName("assetTagNames", LocaleUtil.US);

    @Override
    @Test
    public void testMultiwordPrefixes() throws Exception {
        this.addDocument("Name Tags");
        this.addDocument("Names Tab");
        this.addDocument("Tabs Names Tags");
        this.addDocument("Tag Names");
        List<String> results1 = Arrays.asList("Name Tags", "Names Tab", "Tabs Names Tags", "Tag Names");
        this.assertSearch("name ta", results1);
        this.assertSearch("names ta", results1);
        List<String> results2 = Arrays.asList("Names Tab", "Tabs Names Tags", "Name Tags", "Tag Names");
        this.assertSearch("name tab", results2);
        this.assertSearch("name tabs", results2);
        this.assertSearch("names tab", results2);
        this.assertSearch("names tabs", results2);
        List<String> results3 = Arrays.asList("Name Tags", "Tabs Names Tags", "Tag Names", "Names Tab");
        this.assertSearch("name tag", results3);
        this.assertSearch("name tags", results3);
        this.assertSearch("names tag", results3);
        this.assertSearch("names tags", results3);
        List<String> results4 = Arrays.asList("Tabs Names Tags", "Names Tab");
        this.assertSearch("tab na", results4);
        List<String> results5 = Arrays.asList("Tabs Names Tags", "Names Tab", "Name Tags", "Tag Names");
        this.assertSearch("tab names", results5);
        this.assertSearch("tabs names", results5);
        this.assertSearch("tabs names tags", results5);
        this.assertSearch("tags names tabs", results5);
        List<String> results6 = Arrays.asList("Names Tab", "Tabs Names Tags");
        this.assertSearch("tabs na ta", results6);
        List<String> results7 = Arrays.asList("Tag Names", "Name Tags", "Tabs Names Tags");
        this.assertSearch("tag na", results7);
        List<String> results8 = Arrays.asList("Tag Names", "Name Tags", "Tabs Names Tags", "Names Tab");
        this.assertSearch("tag name", results8);
        this.assertSearch("tag names", results8);
        this.assertSearch("tags names", results8);
        List<String> results9 = Arrays.asList("Name Tags", "Tag Names", "Tabs Names Tags");
        this.assertSearch("tags na ta", results9);
        this.assertSearch("zz name", 4);
        this.assertSearch("zz names", 4);
        this.assertSearch("zz tab", 2);
        this.assertSearch("zz tabs", 2);
        this.assertSearch("zz tag", 3);
        this.assertSearch("zz tags", 3);
        this.assertSearchNoHits("zz na");
        this.assertSearchNoHits("zz ta");
    }

    @Override
    @Test
    public void testPhrases() throws Exception {
        this.addDocument("Names of Tags");
        this.addDocument("More names of tags here");
        this.assertSearch("\"HERE\"", 1);
        this.assertSearch("\"more\"   names   \"here\"", 1);
        this.assertSearch("\"More\"", 1);
        this.assertSearch("\"more\"", 1);
        this.assertSearch("\"names of tags\"", 2);
        this.assertSearch("\"NAmes\" \"TAGS\"", 2);
        this.assertSearch("\"names\" MORE \"tags\"", 1);
        this.assertSearch("\"Tags here\"", 1);
        this.assertSearch("\"Tags\" here", 1);
        this.assertSearch("\"TAGS\"", 2);
        this.assertSearch("\"   more   \"   tags   \"   here   \"", 1);
        this.assertSearchNoHits("\"more\" other \"here\"");
        this.assertSearchNoHits("\"name\" of \"tags\"");
        this.assertSearchNoHits("\"names\" of \"tAgs\"");
    }

    @Override
    @Test
    public void testStopwords() throws Exception {
        this.addDocument("Names of Tags");
        this.addDocument("More names of tags");
        this.assertSearchNoHits("of");
        this.assertSearch("Names of tags", 2);
        this.assertSearch("tags names", 2);
    }

    @Override
    protected String getField() {
        return _FIELD;
    }

    private static String _getLocalizedName(String name, Locale locale) {
        LocalizationImpl localization = new LocalizationImpl();
        return localization.getLocalizedName(name, LocaleUtil.toLanguageId(locale));
    }
}

