/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.indexing;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.test.util.PropsTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PropsUtil;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.mockito.Mockito;

public class DocumentFixture {
    protected Props props;
    private FastDateFormatFactory _fastDateFormatFactory;
    private Props _props;

    public static Document newDocument(long companyId, long groupId, String entryClassName) {
        DocumentImpl document = new DocumentImpl();
        document.addKeyword("companyId", companyId);
        document.addKeyword("groupId", groupId);
        long entryClassPK = RandomTestUtil.randomLong();
        document.addUID(entryClassName, entryClassPK);
        DocumentHelper documentHelper = new DocumentHelper(document);
        documentHelper.setEntryKey(entryClassName, entryClassPK);
        return document;
    }

    public void setUp() {
        this.setUpFastDateFormatFactoryUtil();
        this.setUpPropsUtil();
    }

    public void tearDown() {
        this.tearDownFastDateFormatFactoryUtil();
        this.tearDownPropsUtil();
    }

    protected void setUpFastDateFormatFactoryUtil() {
        this._fastDateFormatFactory = FastDateFormatFactoryUtil.getFastDateFormatFactory();
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        FastDateFormatFactory fastDateFormatFactory = (FastDateFormatFactory)Mockito.mock(FastDateFormatFactory.class);
        Mockito.when((Object)fastDateFormatFactory.getSimpleDateFormat("yyyyMMddHHmmss")).thenReturn((Object)new SimpleDateFormat("yyyyMMddHHmmss"));
        fastDateFormatFactoryUtil.setFastDateFormatFactory(fastDateFormatFactory);
    }

    protected void setUpPropsUtil() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("index.date.format.pattern", "yyyyMMddHHmmss");
        properties.put("index.search.collated.spell.check.result.enabled", "true");
        properties.put("index.search.collated.spell.check.result.scores.threshold", "50");
        properties.put("index.search.highlight.fragment.size", "80");
        properties.put("index.search.highlight.require.field.match", "true");
        properties.put("index.search.highlight.snippet.size", "3");
        properties.put("index.search.query.indexing.enabled", "true");
        properties.put("index.search.query.indexing.threshold", "50");
        properties.put("index.search.query.suggestion.enabled", "true");
        properties.put("index.search.query.suggestion.max", "yyyyMMddHHmmss");
        properties.put("index.search.query.suggestion.scores.threshold", "0");
        properties.put("index.search.scoring.enabled", "true");
        properties.put("index.sortable.text.fields.truncated.length", "255");
        this.props = PropsTestUtil.setProps(properties);
    }

    protected void tearDownFastDateFormatFactoryUtil() {
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory(this._fastDateFormatFactory);
        this._fastDateFormatFactory = null;
    }

    protected void tearDownPropsUtil() {
        PropsUtil.setProps(this._props);
        this._props = null;
        this.props = null;
    }
}

