/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.filter.tags;

import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.search.internal.contributor.query.AssetTagNamesQueryPreFilterContributor;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;

public abstract class BaseAssetTagNamesQueryPreFilterContributorTestCase
extends BaseIndexingTestCase {
    protected static final String FIELD = "assetTagNames";

    @Test
    public void testAssetTagNamesQueryPreFilter() throws Exception {
        String[] tagNames = new String[]{"tagNameOne", "tagNameThree tagNameTwo"};
        this.addDocuments(tagNames);
        this.assertSearch(tagNames[0], Arrays.asList(tagNames[0]));
        this.assertSearch(tagNames[1], Arrays.asList(tagNames[1]));
    }

    protected void addDocuments(String ... values) throws Exception {
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(FIELD, value), Arrays.asList(values));
    }

    protected void assertSearch(String queryString, List<String> expectedValues) throws Exception {
        this.assertSearch(indexingTestHelper -> {
            AssetTagNamesQueryPreFilterContributor contributor = new AssetTagNamesQueryPreFilterContributor();
            BooleanFilter booleanFilter = new BooleanFilter();
            SearchContext searchContext = indexingTestHelper.getSearchContext();
            searchContext.setAssetTagNames(new String[]{queryString});
            contributor.contribute(booleanFilter, searchContext);
            indexingTestHelper.setFilter(booleanFilter);
            indexingTestHelper.search();
            indexingTestHelper.assertValues(FIELD, expectedValues);
        });
    }
}

