/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.filter;

import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Arrays;
import org.junit.Test;

public abstract class BaseTermFilterTestCase
extends BaseIndexingTestCase {
    private static final String _FIELD = "folderId";

    @Test
    public void testBasicSearch() throws Exception {
        this.index("One");
        this.assertTermFilter("One", "One");
        this.assertTermFilter("one", "");
    }

    @Test
    public void testLuceneSpecialCharacters() throws Exception {
        String value = "One\\+-!():^[]\"{}~*?|&/Two";
        this.index(value);
        this.assertTermFilter(value, value);
    }

    @Test
    public void testSolrSpecialCharacters() throws Exception {
        String value = "One\\+-!():^[]\"{}~*?|&/; Two";
        this.index(value);
        this.assertTermFilter(value, value);
    }

    @Test
    public void testSpaces() throws Exception {
        this.index("One Two");
        this.assertTermFilter("One Two", "One Two");
        this.assertTermFilter("One", "");
        this.assertTermFilter("Two", "");
    }

    protected void assertTermFilter(String filterValue, String expectedValue) throws Exception {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.setFilter(new TermFilter(_FIELD, filterValue));
            indexingTestHelper.search();
            indexingTestHelper.assertValues(_FIELD, Arrays.asList(expectedValue));
        });
    }

    protected void index(String value) throws Exception {
        this.addDocument(DocumentCreationHelpers.singleKeyword(_FIELD, value));
    }
}

