/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.filter;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.search.filter.DateRangeFilterBuilder;
import com.liferay.portal.search.internal.filter.DateRangeFilterBuilderImpl;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.junit.Test;

public abstract class BaseDateRangeFilterTestCase
extends BaseIndexingTestCase {
    protected static final String FIELD = "expirationDate";
    protected DateRangeFilterBuilder dateRangeFilterBuilder = this.createDateRangeFilterBuilder();

    @Test
    public void testBeforeLowerBound() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001123000000");
        this.assertNoHits();
    }

    @Test
    public void testBeforeRange() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001123000000");
        this.dateRangeFilterBuilder.setTo("20001124000000");
        this.assertNoHits();
    }

    @Test
    public void testBeforeUpperBound() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setTo("20001123000000");
        this.assertHits("20001122000000");
    }

    @Test
    public void testLowerBoundExclusive() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001122000000");
        this.dateRangeFilterBuilder.setIncludeLower(false);
        this.assertNoHits();
    }

    @Test
    public void testLowerBoundInclusive() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001122000000");
        this.dateRangeFilterBuilder.setIncludeLower(true);
        this.assertHits("20001122000000");
    }

    @Test
    public void testPastLowerBound() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001121000000");
        this.assertHits("20001122000000");
    }

    @Test
    public void testPastRange() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001120000000");
        this.dateRangeFilterBuilder.setTo("20001121000000");
        this.assertNoHits();
    }

    @Test
    public void testPastUpperBound() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setTo("20001121000000");
        this.assertNoHits();
    }

    @Test
    public void testRange() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001121000000");
        this.dateRangeFilterBuilder.setTo("20001123000000");
        this.assertHits("20001122000000");
    }

    @Test
    public void testRangeExclusive() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001122000000");
        this.dateRangeFilterBuilder.setTo("20001122000000");
        this.assertNoHits();
    }

    @Test
    public void testRangeInclusive() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001122000000");
        this.dateRangeFilterBuilder.setIncludeLower(true);
        this.dateRangeFilterBuilder.setIncludeUpper(true);
        this.dateRangeFilterBuilder.setTo("20001122000000");
        this.assertHits("20001122000000");
    }

    @Test
    public void testRangeLowerBoundExclusive() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001122000000");
        this.dateRangeFilterBuilder.setTo("20001123000000");
        this.assertNoHits();
    }

    @Test
    public void testRangeLowerBoundInclusive() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001122000000");
        this.dateRangeFilterBuilder.setIncludeLower(true);
        this.dateRangeFilterBuilder.setTo("20001123000000");
        this.assertHits("20001122000000");
    }

    @Test
    public void testRangeUpperBoundExclusive() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001121000000");
        this.dateRangeFilterBuilder.setTo("20001122000000");
        this.assertNoHits();
    }

    @Test
    public void testRangeUpperBoundInclusive() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setFrom("20001121000000");
        this.dateRangeFilterBuilder.setIncludeUpper(true);
        this.dateRangeFilterBuilder.setTo("20001122000000");
        this.assertHits("20001122000000");
    }

    @Test
    public void testUpperBoundExclusive() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setIncludeUpper(false);
        this.dateRangeFilterBuilder.setTo("20001122000000");
        this.assertNoHits();
    }

    @Test
    public void testUpperBoundInclusive() throws Exception {
        this.addDocument(this.getDate(2000, 11, 22));
        this.dateRangeFilterBuilder.setIncludeUpper(true);
        this.dateRangeFilterBuilder.setTo("20001122000000");
        this.assertHits("20001122000000");
    }

    protected void addDocument(Date date) throws Exception {
        this.addDocument(DocumentCreationHelpers.singleDate(FIELD, date));
    }

    protected void assertHits(String ... expectedValues) throws Exception {
        this.assertSearch(Arrays.asList(expectedValues));
    }

    protected void assertNoHits() throws Exception {
        this.assertSearch(Arrays.asList(new String[0]));
    }

    protected void assertSearch(List<String> expectedValues) throws Exception {
        this.assertSearch((BaseIndexingTestCase.IndexingTestHelper indexingTestHelper) -> {
            indexingTestHelper.setFilter(this.dateRangeFilterBuilder.build());
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> DocumentsAssert.assertValues(indexingTestHelper.getRequestString(), hits.getDocs(), FIELD, expectedValues));
        });
    }

    protected DateRangeFilterBuilder createDateRangeFilterBuilder() {
        DateRangeFilterBuilderImpl dateRangeFilterBuilder = new DateRangeFilterBuilderImpl();
        dateRangeFilterBuilder.setFieldName(FIELD);
        return dateRangeFilterBuilder;
    }

    protected Date getDate(int year, int month, int date) {
        LocalDateTime localDateTime = LocalDateTime.of(year, month, date, 0, 0, 0);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    @Override
    protected void setPreBooleanFilter(Filter filter, Query query) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add(filter, BooleanClauseOccur.MUST);
        query.setPreBooleanFilter(booleanFilter);
    }
}

