/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.facet;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.SimpleFacet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.search.test.util.facet.BaseFacetTestCase;
import com.liferay.portal.search.test.util.indexing.QueryContributors;
import java.io.Serializable;
import java.util.Arrays;
import org.junit.Test;

public abstract class BaseSimpleFacetTestCase
extends BaseFacetTestCase {
    @Test
    public void testFrequencyThreshold() throws Exception {
        this.addDocuments(6, "one");
        this.addDocuments(5, "two");
        this.addDocuments(4, "three");
        this.addDocuments(3, "four");
        this.addDocuments(2, "five");
        this.addDocuments(1, "six");
        this.assertSearchFacet(helper -> {
            Facet facet = helper.addFacet(this::createFacet);
            this.setFrequencyThreshold(facet, 4);
            this.setMaxTerms(facet, 5);
            helper.search();
            helper.assertFrequencies(facet, Arrays.asList("one=6", "two=5", "three=4"));
        });
        this.assertSearchFacet(helper -> {
            Facet facet = helper.addFacet(this::createFacet);
            this.setFrequencyThreshold(facet, 4);
            this.setMaxTerms(facet, 2);
            helper.search();
            helper.assertFrequencies(facet, Arrays.asList("one=6", "two=5"));
        });
    }

    @Test
    public void testMaxTerms() throws Exception {
        this.addDocuments(6, "One");
        this.addDocuments(5, "TWO");
        this.addDocuments(4, "ThReE");
        this.addDocuments(3, "four");
        this.addDocuments(2, "fivE");
        this.assertSearchFacet(helper -> {
            Facet facet = helper.addFacet(this::createFacet);
            this.setMaxTerms(facet, 1);
            helper.search();
            helper.assertFrequencies(facet, Arrays.asList("One=6"));
        });
        this.assertSearchFacet(helper -> {
            Facet facet = helper.addFacet(this::createFacet);
            this.setMaxTerms(facet, 5);
            helper.search();
            helper.assertFrequencies(facet, Arrays.asList("One=6", "TWO=5", "ThReE=4", "four=3", "fivE=2"));
        });
    }

    @Test
    public void testMaxTermsNegative() throws Exception {
        this.addDocument("One");
        this.assertSearchFacet(helper -> {
            Facet facet = helper.addFacet(this::createFacet);
            this.setMaxTerms(facet, -25);
            helper.search();
            helper.assertFrequencies(facet, Arrays.asList("One=1"));
        });
    }

    @Test
    public void testMaxTermsZero() throws Exception {
        this.addDocument("One");
        this.assertSearchFacet(helper -> {
            Facet facet = helper.addFacet(this::createFacet);
            this.setMaxTerms(facet, 0);
            helper.search();
            helper.assertFrequencies(facet, Arrays.asList("One=1"));
        });
    }

    @Test
    public void testSelection() throws Exception {
        this.addDocuments(6, "one");
        this.addDocuments(5, "two");
        this.addDocuments(4, "three");
        this.addDocuments(3, "four");
        this.addDocuments(2, "five");
        this.assertSearchFacet(helper -> {
            Facet facet = helper.addFacet(this::createFacet);
            this.select(facet, "three", (BaseFacetTestCase.FacetTestHelper)helper);
            helper.search();
            helper.assertResultCount(4);
            helper.assertFrequencies(facet, Arrays.asList("one=6", "two=5", "three=4", "four=3", "five=2"));
        });
    }

    @Test
    public void testUnmatchedAreIgnored() throws Exception {
        String presentButUnmatched = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.addDocument("One");
        this.addDocument(presentButUnmatched);
        this.assertSearchFacet(helper -> {
            Facet facet = helper.addFacet(this::createFacet);
            helper.setQueryContributor(QueryContributors.mustNotTerm(this.getField(), presentButUnmatched));
            helper.search();
            helper.assertFrequencies(facet, Arrays.asList("One=1"));
        });
    }

    protected Facet createFacet(SearchContext searchContext) {
        SimpleFacet facet = new SimpleFacet(searchContext);
        this.initFacet(facet);
        facet.setFieldName("status");
        return facet;
    }

    @Override
    protected String getField() {
        return "status";
    }

    protected void select(Facet facet, String value, BaseFacetTestCase.FacetTestHelper facetTestHelper) {
        facetTestHelper.setSearchContextAttribute(facet.getFieldId(), (Serializable)((Object)value));
    }

    protected void setFrequencyThreshold(Facet facet, int frequencyThreshold) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        JSONObject jsonObject = facetConfiguration.getData();
        jsonObject.put("frequencyThreshold", frequencyThreshold);
    }

    protected void setMaxTerms(Facet facet, int maxTerms) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        JSONObject jsonObject = facetConfiguration.getData();
        jsonObject.put("maxTerms", maxTerms);
    }
}

