/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.facet;

import com.liferay.portal.json.JSONFactoryImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.search.facet.FacetFactory;
import com.liferay.portal.search.facet.modified.ModifiedFacetFactory;
import com.liferay.portal.search.facet.site.SiteFacetFactory;
import com.liferay.portal.search.facet.tag.AssetTagNamesFacetFactory;
import com.liferay.portal.search.facet.user.UserFacetFactory;
import com.liferay.portal.search.internal.facet.modified.ModifiedFacetFactoryImpl;
import com.liferay.portal.search.internal.facet.site.SiteFacetFactoryImpl;
import com.liferay.portal.search.internal.facet.tag.AssetTagNamesFacetFactoryImpl;
import com.liferay.portal.search.internal.facet.user.UserFacetFactoryImpl;
import com.liferay.portal.search.internal.filter.FilterBuildersImpl;
import com.liferay.portal.search.test.util.FacetsAssert;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseAggregationFilteringTestCase
extends BaseIndexingTestCase {
    protected static final String MOD = "mod";
    protected static final String SIT = "sit";
    protected static final String TAG = "tag";
    protected static final String USE = "use";
    protected AssetTagNamesFacetFactory assetTagNamesFacetFactory = new AssetTagNamesFacetFactoryImpl();
    protected ModifiedFacetFactory modifiedFacetFactory = this.createModifiedFacetFactory();
    protected SiteFacetFactory siteFacetFactory = new SiteFacetFactoryImpl();
    protected UserFacetFactory userFacetFactory = new UserFacetFactoryImpl();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setUpJSONFactoryUtil();
    }

    @Test
    public void testAggregationUnfiltered() throws Exception {
        this.addDocument("tab", "20180602100837", 111L, "u ab");
        this.addDocument("tbc", "20180602100837", 222L, "u cd");
        this.addDocument("tde", "20180602100847", 222L, "u ab");
        this.addDocument("tde", "20180602100857", 111L, "u cd");
        this.assertSearchAggregationFiltering(helper -> {
            helper.search();
            helper.assertResultCount(4);
            helper.assertFrequencies(MOD, Arrays.asList("[20180602100830 TO 20180602100839]=2", "[20180602100840 TO 20180602100849]=1", "[20180602100850 TO 20180602100859]=1"));
            helper.assertFrequencies(SIT, Arrays.asList("111=2", "222=2"));
            helper.assertFrequencies(TAG, Arrays.asList("tde=2", "tab=1", "tbc=1"));
            helper.assertFrequencies(USE, Arrays.asList("u ab=2", "u cd=2"));
        });
    }

    @Test
    public void testBasicFacetSelection() throws Exception {
        this.addDocument("tab", "20180602100837", 111L, "u ab");
        this.addDocument("tbc", "20180602100837", 222L, "u cd");
        this.addDocument("tde", "20180602100847", 222L, "u ab");
        this.addDocument("tde", "20180602100857", 111L, "u cd");
        this.assertSearchAggregationFiltering(helper -> {
            helper.setSearchContextAttribute("search.basic.facet.selection", Boolean.TRUE);
            helper.select(MOD, "[20180602100850 TO 20180602100859]");
            helper.select(SIT, "111");
            helper.select(TAG, "tde");
            helper.select(USE, "u cd");
            helper.search();
            helper.assertResultCount(1);
            helper.assertFrequencies(MOD, Arrays.asList("[20180602100830 TO 20180602100839]=2", "[20180602100840 TO 20180602100849]=1", "[20180602100850 TO 20180602100859]=1"));
            helper.assertFrequencies(SIT, Arrays.asList("111=2", "222=2"));
            helper.assertFrequencies(TAG, Arrays.asList("tde=2", "tab=1", "tbc=1"));
            helper.assertFrequencies(USE, Arrays.asList("u ab=2", "u cd=2"));
        });
    }

    @Test
    public void testSelectModified() throws Exception {
        this.addDocument("tab", "20180602100837", 111L, "u ab");
        this.addDocument("tbc", "20180602100837", 222L, "u cd");
        this.addDocument("tde", "20180602100847", 222L, "u ab");
        this.addDocument("tde", "20180602100857", 111L, "u cd");
        this.assertSearchAggregationFiltering(helper -> {
            helper.select(MOD, "[20180602100830 TO 20180602100839]");
            helper.search();
            helper.assertResultCount(2);
            helper.assertFrequencies(MOD, Arrays.asList("[20180602100830 TO 20180602100839]=2", "[20180602100840 TO 20180602100849]=1", "[20180602100850 TO 20180602100859]=1"));
            helper.assertFrequencies(SIT, Arrays.asList("111=1", "222=1"));
            helper.assertFrequencies(TAG, Arrays.asList("tab=1", "tbc=1"));
            helper.assertFrequencies(USE, Arrays.asList("u ab=1", "u cd=1"));
        });
    }

    @Test
    public void testSelectSite() throws Exception {
        this.addDocument("tab", "20180602100837", 111L, "u ab");
        this.addDocument("tbc", "20180602100837", 222L, "u cd");
        this.addDocument("tde", "20180602100847", 222L, "u ab");
        this.addDocument("tde", "20180602100857", 111L, "u cd");
        this.assertSearchAggregationFiltering(helper -> {
            helper.select(SIT, "111");
            helper.search();
            helper.assertResultCount(2);
            helper.assertFrequencies(MOD, Arrays.asList("[20180602100830 TO 20180602100839]=1", "[20180602100840 TO 20180602100849]=0", "[20180602100850 TO 20180602100859]=1"));
            helper.assertFrequencies(SIT, Arrays.asList("111=2", "222=2"));
            helper.assertFrequencies(TAG, Arrays.asList("tab=1", "tde=1"));
            helper.assertFrequencies(USE, Arrays.asList("u ab=1", "u cd=1"));
        });
    }

    @Test
    public void testSelectTag() throws Exception {
        this.addDocument("tab", "20180602100837", 111L, "u ab");
        this.addDocument("tbc", "20180602100837", 222L, "u cd");
        this.addDocument("tde", "20180602100847", 222L, "u ab");
        this.addDocument("tde", "20180602100857", 111L, "u cd");
        this.assertSearchAggregationFiltering(helper -> {
            helper.select(TAG, "tde");
            helper.search();
            helper.assertResultCount(2);
            helper.assertFrequencies(MOD, Arrays.asList("[20180602100830 TO 20180602100839]=0", "[20180602100840 TO 20180602100849]=1", "[20180602100850 TO 20180602100859]=1"));
            helper.assertFrequencies(SIT, Arrays.asList("111=1", "222=1"));
            helper.assertFrequencies(TAG, Arrays.asList("tde=2", "tab=1", "tbc=1"));
            helper.assertFrequencies(USE, Arrays.asList("u ab=1", "u cd=1"));
        });
    }

    @Test
    public void testSelectUser() throws Exception {
        this.addDocument("tab", "20180602100837", 111L, "u ab");
        this.addDocument("tbc", "20180602100837", 222L, "u cd");
        this.addDocument("tde", "20180602100847", 222L, "u ab");
        this.addDocument("tde", "20180602100857", 111L, "u cd");
        this.assertSearchAggregationFiltering(helper -> {
            helper.select(USE, "u ab");
            helper.search();
            helper.assertResultCount(2);
            helper.assertFrequencies(MOD, Arrays.asList("[20180602100830 TO 20180602100839]=1", "[20180602100840 TO 20180602100849]=1", "[20180602100850 TO 20180602100859]=0"));
            helper.assertFrequencies(SIT, Arrays.asList("111=1", "222=1"));
            helper.assertFrequencies(TAG, Arrays.asList("tab=1", "tde=1"));
            helper.assertFrequencies(USE, Arrays.asList("u ab=2", "u cd=2"));
        });
    }

    @Test
    public void testVariousSelectionsCombined() throws Exception {
        this.addDocument("tab", "20180602100837", 111L, "u ab");
        this.addDocument("tbc", "20180602100837", 222L, "u cd");
        this.addDocument("tde", "20180602100847", 222L, "u ab");
        this.addDocument("tde", "20180602100857", 111L, "u cd");
        this.assertSearchAggregationFiltering(helper -> {
            helper.select(TAG, "tde");
            helper.select(USE, "u cd");
            helper.search();
            helper.assertResultCount(1);
            helper.assertFrequencies(MOD, Arrays.asList("[20180602100830 TO 20180602100839]=0", "[20180602100840 TO 20180602100849]=0", "[20180602100850 TO 20180602100859]=1"));
            helper.assertFrequencies(SIT, Arrays.asList("111=1"));
            helper.assertFrequencies(TAG, Arrays.asList("tbc=1", "tde=1"));
            helper.assertFrequencies(USE, Arrays.asList("u ab=1", "u cd=1"));
        });
    }

    protected static void setConfigurationRanges(com.liferay.portal.search.facet.Facet facet, Collection<String> ranges) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (String range : ranges) {
            JSONObject jsonObject = JSONUtil.put("range", (Object)range);
            jsonArray.put(jsonObject);
        }
        dataJSONObject.put("ranges", jsonArray);
    }

    protected void addDocument(String tag, String modified, long site, String user) throws Exception {
        this.addDocument(document -> {
            document.addKeyword("assetTagNames", tag);
            document.addKeyword("modified", modified);
            document.addNumber("groupId", site);
            document.addKeyword("userName", user);
        });
    }

    protected void assertSearchAggregationFiltering(Consumer<AggregationFilteringTestHelper> consumer) throws Exception {
        IdempotentRetryAssert.retryAssert(5L, TimeUnit.SECONDS, () -> {
            consumer.accept(new AggregationFilteringTestHelper());
            return null;
        });
    }

    protected ModifiedFacetFactoryImpl createModifiedFacetFactory() {
        return new ModifiedFacetFactoryImpl(){
            {
                this.filterBuilders = new FilterBuildersImpl();
            }
        };
    }

    protected Hits doSearch(SearchContext searchContext) {
        return this.search(searchContext);
    }

    protected void setUpJSONFactoryUtil() {
        JSONFactoryUtil jsonFactoryUtil = new JSONFactoryUtil();
        jsonFactoryUtil.setJSONFactory(new JSONFactoryImpl());
    }

    private class AggregationFilteringTestHelper {
        private Hits _hits;
        private final SearchContext _searchContext;

        public AggregationFilteringTestHelper() {
            this._searchContext = BaseAggregationFilteringTestCase.this.createSearchContext();
            this.addFacet(BaseAggregationFilteringTestCase.MOD, this.createModifiedFacet());
            this.addFacet(BaseAggregationFilteringTestCase.SIT, this.createFacet(BaseAggregationFilteringTestCase.this.siteFacetFactory));
            this.addFacet(BaseAggregationFilteringTestCase.TAG, this.createFacet(BaseAggregationFilteringTestCase.this.assetTagNamesFacetFactory));
            this.addFacet(BaseAggregationFilteringTestCase.USE, this.createFacet(BaseAggregationFilteringTestCase.this.userFacetFactory));
        }

        public void assertFrequencies(String aggregationName, List<String> expected) {
            FacetsAssert.assertFrequencies(aggregationName, this._searchContext, expected);
        }

        public void assertResultCount(int expected) {
            Object[] documents = this._hits.getDocs();
            Assert.assertEquals(Arrays.toString(documents), expected, documents.length);
        }

        public void search() {
            this._hits = BaseAggregationFilteringTestCase.this.doSearch(this._searchContext);
        }

        public void select(String aggregationName, String ... selections) {
            com.liferay.portal.search.facet.Facet facet = (com.liferay.portal.search.facet.Facet)this._searchContext.getFacet(aggregationName);
            facet.select(selections);
        }

        public void setSearchContextAttribute(String name, Serializable value) {
            this._searchContext.setAttribute(name, value);
        }

        protected void addFacet(String aggregationName, com.liferay.portal.search.facet.Facet facet) {
            Map<String, Facet> facets = this._searchContext.getFacets();
            facet.setAggregationName(aggregationName);
            facets.put(aggregationName, facet);
        }

        protected com.liferay.portal.search.facet.Facet createFacet(FacetFactory facetFactory) {
            return facetFactory.newInstance(this._searchContext);
        }

        protected com.liferay.portal.search.facet.Facet createModifiedFacet() {
            com.liferay.portal.search.facet.Facet facet = BaseAggregationFilteringTestCase.this.modifiedFacetFactory.newInstance(this._searchContext);
            BaseAggregationFilteringTestCase.setConfigurationRanges(facet, Arrays.asList("[20180602100830 TO 20180602100839]", "[20180602100840 TO 20180602100849]", "[20180602100850 TO 20180602100859]"));
            return facet;
        }
    }
}

