/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.count;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseCountTestCase
extends BaseIndexingTestCase {
    private static final String _FIELD = "test-field";
    private static final int _TOTAL_DOCUMENTS = 20;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        for (int i = 0; i < 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleText(_FIELD, StringUtil.toLowerCase(this.testName.getMethodName())));
        }
    }

    @Test
    public void testAll() throws Exception {
        this.assertSearch(indexingTestHelper -> Assert.assertEquals(20L, indexingTestHelper.searchCount()));
    }

    @Test
    public void testPaginationIsIgnored() throws Exception {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> {
                int start = 5;
                searchContext.setEnd(start - 1);
                searchContext.setStart(start);
            });
            Assert.assertEquals(20L, indexingTestHelper.searchCount());
        });
    }

    @Test
    public void testPostFilterWithoutMainQuery() throws Exception {
        this.assertSearch(indexingTestHelper -> {
            BooleanQueryImpl query = new BooleanQueryImpl();
            query.setPostFilter(this._createBooleanFilter());
            indexingTestHelper.setQuery(query);
            Assert.assertEquals(20L, indexingTestHelper.searchCount());
        });
    }

    @Test
    public void testPreFilterWithoutMainQuery() throws Exception {
        this.assertSearch(indexingTestHelper -> {
            BooleanQueryImpl query = new BooleanQueryImpl();
            query.setPreBooleanFilter(this._createBooleanFilter());
            indexingTestHelper.setQuery(query);
            Assert.assertEquals(20L, indexingTestHelper.searchCount());
        });
    }

    private BooleanFilter _createBooleanFilter() {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add(new TermFilter(_FIELD, StringUtil.toLowerCase(this.testName.getMethodName())), BooleanClauseOccur.MUST);
        return booleanFilter;
    }
}

