/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.pipeline.StatsBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.StatsBucketPipelineAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseStatsBucketPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testStatsBucketPipeline() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        StatsBucketPipelineAggregation statsBucketPipelineAggregation = this.aggregations.statsBucket("stats_bucket", "histogram>sum");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                searchRequestBuilder.addAggregation(this.aggregationFixture.getDefaultHistogramAggregation());
                searchRequestBuilder.addPipelineAggregation(statsBucketPipelineAggregation);
            });
            indexingTestHelper.search();
            StatsBucketPipelineAggregationResult statsBucketPipelineAggregationResult = (StatsBucketPipelineAggregationResult)indexingTestHelper.getAggregationResult(statsBucketPipelineAggregation);
            Assert.assertEquals("Avg summged in buckets", 42.0, statsBucketPipelineAggregationResult.getAvg(), 0.0);
            Assert.assertEquals("Total count in buckets", 5.0f, statsBucketPipelineAggregationResult.getCount(), 0.0f);
            Assert.assertEquals("Max summed priority in buckets", 85.0, statsBucketPipelineAggregationResult.getMax(), 0.0);
            Assert.assertEquals("Min summed priority in buckets", 10.0, statsBucketPipelineAggregationResult.getMin(), 0.0);
            Assert.assertEquals("Summed priority in buckets", 210.0, statsBucketPipelineAggregationResult.getSum(), 0.0);
        });
    }
}

