/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.pipeline.PercentilesBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PercentilesBucketPipelineAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class BasePercentilesPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testPercentiles() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        PercentilesBucketPipelineAggregation percentilesBucketPipelineAggregation = this.getAggregation();
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                searchRequestBuilder.addAggregation(this.aggregationFixture.getDefaultHistogramAggregation());
                searchRequestBuilder.addPipelineAggregation(percentilesBucketPipelineAggregation);
            });
            indexingTestHelper.search();
            PercentilesBucketPipelineAggregationResult percentilesBucketPipelineAggregationResult = (PercentilesBucketPipelineAggregationResult)indexingTestHelper.getAggregationResult(percentilesBucketPipelineAggregation);
            Map<Double, Double> percentiles = percentilesBucketPipelineAggregationResult.getPercentiles();
            Assert.assertEquals("Total number of buckets", 7.0f, percentiles.size(), 0.0f);
            Assert.assertEquals("1%", 10.0, percentiles.get(1.0), 0.0);
            Assert.assertEquals("5%", 10.0, percentiles.get(5.0), 0.0);
            Assert.assertEquals("25.%", 20.0, percentiles.get(25.0), 0.0);
            Assert.assertEquals("50%", 35.0, percentiles.get(50.0), 0.0);
            Assert.assertEquals("75%", 60.0, percentiles.get(75.0), 0.0);
            Assert.assertEquals("95%", 85.0, percentiles.get(95.0), 0.0);
            Assert.assertEquals("99%", 85.0, percentiles.get(99.0), 0.0);
        });
    }

    @Test
    public void testPercentilesWithSpecifiedPercents() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        PercentilesBucketPipelineAggregation percentilesBucketPipelineAggregation = this.getAggregation();
        percentilesBucketPipelineAggregation.setPercents(25.0, 50.0, 75.0);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                searchRequestBuilder.addAggregation(this.aggregationFixture.getDefaultHistogramAggregation());
                searchRequestBuilder.addPipelineAggregation(percentilesBucketPipelineAggregation);
            });
            indexingTestHelper.search();
            PercentilesBucketPipelineAggregationResult percentilesBucketPipelineAggregationResult = (PercentilesBucketPipelineAggregationResult)indexingTestHelper.getAggregationResult(percentilesBucketPipelineAggregation);
            Map<Double, Double> percentiles = percentilesBucketPipelineAggregationResult.getPercentiles();
            Assert.assertEquals("Total number of buckets", 3.0f, percentiles.size(), 0.0f);
            Assert.assertEquals("25%", 20.0, percentiles.get(25.0), 0.0);
            Assert.assertEquals("50%", 35.0, percentiles.get(50.0), 0.0);
            Assert.assertEquals("75%", 60.0, percentiles.get(75.0), 0.0);
        });
    }

    protected PercentilesBucketPipelineAggregation getAggregation() {
        return this.aggregations.percentilesBucket("percentiles", "histogram>sum");
    }
}

