/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.pipeline.MinBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.MinBucketPipelineAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseMinBucketPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testMinBucketPipeline() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        MinBucketPipelineAggregation minBucketPipelineAggregation = this.aggregations.minBucket("min_bucket", "histogram>sum");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                searchRequestBuilder.addAggregation(this.aggregationFixture.getDefaultHistogramAggregation());
                searchRequestBuilder.addPipelineAggregation(minBucketPipelineAggregation);
            });
            indexingTestHelper.search();
            MinBucketPipelineAggregationResult minBucketPipelineAggregationResult = (MinBucketPipelineAggregationResult)indexingTestHelper.getAggregationResult(minBucketPipelineAggregation);
            Assert.assertEquals("Min summed priority in buckets", 10.0, minBucketPipelineAggregationResult.getValue(), 0.0);
        });
    }
}

