/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.pipeline.MaxBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.MaxBucketPipelineAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseMaxBucketPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testMaxBucketPipeline() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        MaxBucketPipelineAggregation maxBucketPipelineAggregation = this.aggregations.maxBucket("max_bucket", "histogram>sum");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                searchRequestBuilder.addAggregation(this.aggregationFixture.getDefaultHistogramAggregation());
                searchRequestBuilder.addPipelineAggregation(maxBucketPipelineAggregation);
            });
            indexingTestHelper.search();
            MaxBucketPipelineAggregationResult maxBucketPipelineAggregationResult = (MaxBucketPipelineAggregationResult)indexingTestHelper.getAggregationResult(maxBucketPipelineAggregation);
            Assert.assertEquals("Max summed priority in buckets", 85.0, maxBucketPipelineAggregationResult.getValue(), 0.0);
        });
    }
}

