/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.metrics.ExtendedStatsAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.ExtendedStatsBucketPipelineAggregation;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseExtendedStatsBucketPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testStatsBucketPipeline() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        ExtendedStatsBucketPipelineAggregation pipelineAggregation = this.aggregations.extendedStatsBucket("extended_stats_bucket", "histogram>sum");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                searchRequestBuilder.addAggregation(this.aggregationFixture.getDefaultHistogramAggregation());
                searchRequestBuilder.addPipelineAggregation(pipelineAggregation);
            });
            indexingTestHelper.search();
            ExtendedStatsAggregationResult extendedStatsAggregationResult = (ExtendedStatsAggregationResult)indexingTestHelper.getAggregationResult(pipelineAggregation);
            Assert.assertEquals("Avg summed in buckets", 42.0, extendedStatsAggregationResult.getAvg(), 0.0);
            Assert.assertEquals("Total count in buckets", 5.0f, extendedStatsAggregationResult.getCount(), 0.0f);
            Assert.assertEquals("Max summed priority in buckets", 85.0, extendedStatsAggregationResult.getMax(), 0.0);
            Assert.assertEquals("Min summed priority in buckets", 10.0, extendedStatsAggregationResult.getMin(), 0.0);
            Assert.assertEquals("Summed priority in buckets", 210.0, extendedStatsAggregationResult.getSum(), 0.0);
            Assert.assertEquals("Std deviation of summed priority in buckets", 27.313000567495326, extendedStatsAggregationResult.getStdDeviation(), 0.0);
            Assert.assertEquals("Sum of squares of summed priority in buckets", 12550.0, extendedStatsAggregationResult.getSumOfSquares(), 0.0);
            Assert.assertEquals("Variance of summed priority in buckets", 746.0, extendedStatsAggregationResult.getVariance(), 0.0);
        });
    }
}

