/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregation;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.DerivativePipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.DerivativePipelineAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseDerivativePipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testDerivative() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        HistogramAggregation histogramAggregation = this.aggregationFixture.getDefaultHistogramAggregation();
        DerivativePipelineAggregation derivativePipelineAggregation = this.aggregations.derivative("derivative", "sum");
        histogramAggregation.addPipelineAggregation(derivativePipelineAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(histogramAggregation));
            indexingTestHelper.search();
            HistogramAggregationResult histogramAggregationResult = (HistogramAggregationResult)indexingTestHelper.getAggregationResult(histogramAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(histogramAggregationResult.getBuckets());
            Assert.assertEquals("Number of buckets", 5L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "0.0", 4L, null);
            this.assertBucket((Bucket)buckets.get(1), "5.0", 5L, 25.0);
            this.assertBucket((Bucket)buckets.get(2), "10.0", 5L, 25.0);
            this.assertBucket((Bucket)buckets.get(3), "15.0", 5L, 25.0);
            this.assertBucket((Bucket)buckets.get(4), "20.0", 1L, -65.0);
        });
    }

    protected void assertBucket(Bucket bucket, String expectedKey, long expectedCount, Double derivativeValue) {
        Assert.assertEquals(expectedKey, bucket.getKey());
        Assert.assertEquals(expectedCount, bucket.getDocCount());
        Map<String, AggregationResult> childrenAggregationResults = bucket.getChildrenAggregationResults();
        DerivativePipelineAggregationResult derivativePipelineAggregationResult = (DerivativePipelineAggregationResult)childrenAggregationResults.get("derivative");
        if (derivativeValue != null) {
            Assert.assertNotNull(derivativePipelineAggregationResult);
            Assert.assertEquals("Derivative value", derivativeValue, derivativePipelineAggregationResult.getNormalizedValue(), 0.0);
        }
    }
}

