/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregation;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.BucketScriptPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.BucketScriptPipelineAggregationResult;
import com.liferay.portal.search.script.Script;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseBucketScriptPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testBucketScript() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        HistogramAggregation histogramAggregation = this.aggregationFixture.getDefaultHistogramAggregation();
        Script script = this.scripts.script("params.sum * 50");
        BucketScriptPipelineAggregation bucketScriptPipelineAggregation = this.aggregations.bucketScript("bucket_script", script);
        bucketScriptPipelineAggregation.addBucketPath("sum", "sum");
        histogramAggregation.addPipelineAggregation(bucketScriptPipelineAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(histogramAggregation));
            indexingTestHelper.search();
            HistogramAggregationResult histogramAggregationResult = (HistogramAggregationResult)indexingTestHelper.getAggregationResult(histogramAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(histogramAggregationResult.getBuckets());
            Assert.assertEquals("Number of buckets", 5L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "0.0", 4L, 500.0);
            this.assertBucket((Bucket)buckets.get(1), "5.0", 5L, 1750.0);
            this.assertBucket((Bucket)buckets.get(2), "10.0", 5L, 3000.0);
            this.assertBucket((Bucket)buckets.get(3), "15.0", 5L, 4250.0);
            this.assertBucket((Bucket)buckets.get(4), "20.0", 1L, 1000.0);
        });
    }

    protected void assertBucket(Bucket bucket, String expectedKey, long expectedCount, Double bucketScriptValue) {
        Assert.assertEquals(expectedKey, bucket.getKey());
        Assert.assertEquals(expectedCount, bucket.getDocCount());
        Map<String, AggregationResult> childrenAggregationResults = bucket.getChildrenAggregationResults();
        BucketScriptPipelineAggregationResult bucketScriptPipelineAggregationResult = (BucketScriptPipelineAggregationResult)childrenAggregationResults.get("bucket_script");
        if (bucketScriptValue != null) {
            Assert.assertNotNull(bucketScriptPipelineAggregationResult);
            Assert.assertEquals("Bucket script value", bucketScriptValue, bucketScriptPipelineAggregationResult.getValue(), 0.0);
        }
    }
}

