/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.pipeline.AvgBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.AvgBucketPipelineAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseAvgBucketPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testAvgBucketPipeline() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        AvgBucketPipelineAggregation pipelineAggregation = this.aggregations.avgBucket("avg_bucket", "histogram>sum");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                searchRequestBuilder.addAggregation(this.aggregationFixture.getDefaultHistogramAggregation());
                searchRequestBuilder.addPipelineAggregation(pipelineAggregation);
            });
            indexingTestHelper.search();
            AvgBucketPipelineAggregationResult avgBucketPipelineAggregationResult = (AvgBucketPipelineAggregationResult)indexingTestHelper.getAggregationResult(pipelineAggregation);
            Assert.assertEquals("Avg summed priority in buckets", 42.0, avgBucketPipelineAggregationResult.getValue(), 0.0);
        });
    }
}

