/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.metrics;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.TermsAggregation;
import com.liferay.portal.search.aggregation.bucket.TermsAggregationResult;
import com.liferay.portal.search.aggregation.metrics.TopHitsAggregation;
import com.liferay.portal.search.aggregation.metrics.TopHitsAggregationResult;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseTopHitsAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testTopHitsAggregation() throws Exception {
        this.addDocument(document -> {
            document.addKeyword("userName", "Jonh");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "Jonh");
            document.addNumber("priority", 2);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "Jonh");
            document.addNumber("priority", 3);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "Bob");
            document.addNumber("priority", 4);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "Bob");
            document.addNumber("priority", 5);
        });
        TermsAggregation termsAggregation = this.aggregations.terms("terms", "userName");
        TopHitsAggregation topHitsAggregation = this.aggregations.topHits("topHits");
        topHitsAggregation.addSortFields(this.sorts.field("priority", SortOrder.DESC));
        topHitsAggregation.setSize(1);
        termsAggregation.addChildAggregation(topHitsAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(termsAggregation));
            indexingTestHelper.search();
            TermsAggregationResult termsAggregationResult = (TermsAggregationResult)indexingTestHelper.getAggregationResult(termsAggregation);
            for (Bucket bucket : termsAggregationResult.getBuckets()) {
                String userName = bucket.getKey();
                if (Objects.equals(userName, "Jonh")) {
                    this.assertBucket(bucket, 3L, 3);
                    continue;
                }
                if (!Objects.equals(userName, "Bob")) continue;
                this.assertBucket(bucket, 2L, 5);
            }
        });
    }

    protected void assertBucket(Bucket bucket, long count, Integer priority) {
        Assert.assertEquals(count, bucket.getDocCount());
        Map<String, AggregationResult> childrenAggregationResults = bucket.getChildrenAggregationResults();
        TopHitsAggregationResult topHitsAggregationResult = (TopHitsAggregationResult)childrenAggregationResults.get("topHits");
        SearchHits searchHits = topHitsAggregationResult.getSearchHits();
        List<SearchHit> searchHitsList = searchHits.getSearchHits();
        SearchHit searchHit = searchHitsList.get(0);
        Document document = searchHit.getDocument();
        if (MapUtil.isNotEmpty(document.getFields())) {
            Assert.assertEquals(priority, document.getInteger("priority"));
        } else {
            Map<String, Object> sourceMap = searchHit.getSourcesMap();
            Assert.assertEquals(priority.toString(), sourceMap.get("priority"));
        }
    }
}

