/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.metrics;

import com.liferay.portal.search.aggregation.metrics.StatsAggregation;
import com.liferay.portal.search.aggregation.metrics.StatsAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseStatsAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testStatsAggregation() throws Exception {
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 50.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 100.0));
        StatsAggregation statsAggregation = this.aggregations.stats("stats", "priority");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(statsAggregation));
            indexingTestHelper.search();
            StatsAggregationResult statsAggregationResult = (StatsAggregationResult)indexingTestHelper.getAggregationResult(statsAggregation);
            Assert.assertEquals(75.0, statsAggregationResult.getAvg(), 0.0);
            Assert.assertEquals(2L, statsAggregationResult.getCount());
            Assert.assertEquals(100.0, statsAggregationResult.getMax(), 0.0);
            Assert.assertEquals(50.0, statsAggregationResult.getMin(), 0.0);
            Assert.assertEquals(150.0, statsAggregationResult.getSum(), 0.0);
        });
    }
}

