/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.metrics;

import com.liferay.portal.search.aggregation.metrics.PercentilesAggregation;
import com.liferay.portal.search.aggregation.metrics.PercentilesAggregationResult;
import com.liferay.portal.search.aggregation.metrics.PercentilesMethod;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class BasePercentilesAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testPercentilesAggregation() throws Exception {
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 10.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 20.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 30.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 40.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 50.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 60.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 70.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 80.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 90.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 100.0));
        PercentilesAggregation percentilesAggregation = this.aggregations.percentiles("percentiles", "priority");
        percentilesAggregation.setPercentilesMethod(PercentilesMethod.HDR);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(percentilesAggregation));
            indexingTestHelper.search();
            PercentilesAggregationResult percentilesAggregationResult = (PercentilesAggregationResult)indexingTestHelper.getAggregationResult(percentilesAggregation);
            Map<Double, Double> percentilesMap = percentilesAggregationResult.getPercentiles();
            double[] percents = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};
            double[] values = new double[]{10.0, 10.0, 30.0078125, 50.0234375, 80.0546875, 100.0546875, 100.0546875};
            for (int i = 0; i < percents.length; ++i) {
                Assert.assertEquals(values[i], (double)percentilesMap.get(percents[i]), 0.0);
            }
        });
    }
}

