/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.metrics;

import com.liferay.portal.search.aggregation.metrics.GeoCentroidAggregation;
import com.liferay.portal.search.aggregation.metrics.GeoCentroidAggregationResult;
import com.liferay.portal.search.geolocation.GeoLocationPoint;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseGeoCentroidAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testGeoCentroidAggregation() throws Exception {
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.374081, 4.91235));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.369219, 4.901618));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.371667, 4.914722));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 51.2229, 4.4052));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.861111, 2.336389));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.86, 2.327));
        GeoCentroidAggregation geoBoundsAggregation = this.aggregations.geoCentroid("geoCentroid", "geoLocation");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(geoBoundsAggregation));
            indexingTestHelper.search();
            GeoCentroidAggregationResult geoCentroidAggregationResult = (GeoCentroidAggregationResult)indexingTestHelper.getAggregationResult(geoBoundsAggregation);
            Assert.assertNotNull(geoCentroidAggregationResult);
            Assert.assertEquals(6L, geoCentroidAggregationResult.getCount());
            GeoLocationPoint geoLocationPoint = geoCentroidAggregationResult.getCentroid();
            Assert.assertEquals(51.009829603135586, (double)geoLocationPoint.getLatitude(), 0.0);
            Assert.assertEquals(3.9662130642682314, (double)geoLocationPoint.getLongitude(), 0.0);
        });
    }
}

