/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.metrics;

import com.liferay.portal.search.aggregation.metrics.GeoBoundsAggregation;
import com.liferay.portal.search.aggregation.metrics.GeoBoundsAggregationResult;
import com.liferay.portal.search.geolocation.GeoLocationPoint;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseGeoBoundsAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testGeoBoundsAggregation() throws Exception {
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.861111, 2.336389));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.86, 2.327));
        GeoBoundsAggregation geoBoundsAggregation = this.aggregations.geoBounds("geoBounds", "geoLocation");
        geoBoundsAggregation.setWrapLongitude(true);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(geoBoundsAggregation));
            indexingTestHelper.search();
            GeoBoundsAggregationResult geoBoundsAggregationResult = (GeoBoundsAggregationResult)indexingTestHelper.getAggregationResult(geoBoundsAggregation);
            Assert.assertNotNull(geoBoundsAggregationResult);
            GeoLocationPoint bottomRightGeoLocationPoint = geoBoundsAggregationResult.getBottomRight();
            Assert.assertNotNull(bottomRightGeoLocationPoint);
            Assert.assertEquals(48.85999997612089, (double)bottomRightGeoLocationPoint.getLatitude(), 0.0);
            Assert.assertEquals(2.3363889567553997, (double)bottomRightGeoLocationPoint.getLongitude(), 0.0);
            GeoLocationPoint topLeftGeoLocationPoint = geoBoundsAggregationResult.getTopLeft();
            Assert.assertNotNull(topLeftGeoLocationPoint);
            Assert.assertEquals(48.86111099738628, (double)topLeftGeoLocationPoint.getLatitude(), 0.0);
            Assert.assertEquals(2.3269999679178, (double)topLeftGeoLocationPoint.getLongitude(), 0.0);
        });
    }
}

