/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.metrics;

import com.liferay.portal.search.aggregation.metrics.ExtendedStatsAggregation;
import com.liferay.portal.search.aggregation.metrics.ExtendedStatsAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseExtendedStatsAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testExtendedStatsAggregation() throws Exception {
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 50.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 100.0));
        ExtendedStatsAggregation extendedStatsAggregation = this.aggregations.extendedStats("extendedStats", "priority");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(extendedStatsAggregation));
            indexingTestHelper.search();
            ExtendedStatsAggregationResult extendedStatsAggregationResult = (ExtendedStatsAggregationResult)indexingTestHelper.getAggregationResult(extendedStatsAggregation);
            Assert.assertEquals(75.0, extendedStatsAggregationResult.getAvg(), 0.0);
            Assert.assertEquals(2L, extendedStatsAggregationResult.getCount());
            Assert.assertEquals(100.0, extendedStatsAggregationResult.getMax(), 0.0);
            Assert.assertEquals(50.0, extendedStatsAggregationResult.getMin(), 0.0);
            Assert.assertEquals(25.0, extendedStatsAggregationResult.getStdDeviation(), 0.0);
            Assert.assertEquals(150.0, extendedStatsAggregationResult.getSum(), 0.0);
            Assert.assertEquals(12500.0, extendedStatsAggregationResult.getSumOfSquares(), 0.0);
            Assert.assertEquals(625.0, extendedStatsAggregationResult.getVariance(), 0.0);
        });
    }
}

