/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.BucketAggregationResult;
import com.liferay.portal.search.aggregation.bucket.Order;
import com.liferay.portal.search.aggregation.bucket.TermsAggregation;
import com.liferay.portal.search.test.util.aggregation.AggregationAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import org.junit.Test;

public abstract class BaseTermsAggregationTestCase
extends BaseIndexingTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        String userName1 = "SomeUser1";
        String userName2 = "SomeUser2";
        String userName3 = "SomeUser3";
        this.index(1, userName1);
        this.index(2, userName2);
        this.index(3, userName3);
        this.index(4, userName1);
        this.index(5, userName2);
        this.index(6, userName3);
        this.index(7, userName1);
        this.index(8, userName2);
        this.index(9, userName1);
        this.index(10, userName2);
        this.index(11, userName2);
    }

    @Test
    public void testTerms() throws Exception {
        TermsAggregation termsAggregation = this.getAggregation();
        this.assertBuckets(termsAggregation, "[SomeUser2=5, SomeUser1=4, SomeUser3=2]");
    }

    @Test
    public void testTermsWithOrder() throws Exception {
        TermsAggregation termsAggregation = this.getAggregation();
        termsAggregation.addOrders(Order.key(true));
        this.assertBuckets(termsAggregation, "[SomeUser1=4, SomeUser2=5, SomeUser3=2]");
    }

    protected void assertBuckets(Aggregation aggregation, String expected) {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(aggregation));
            indexingTestHelper.search();
            AggregationAssert.assertBuckets(expected, (BucketAggregationResult)indexingTestHelper.getAggregationResult(aggregation));
        });
    }

    protected TermsAggregation getAggregation() {
        return this.aggregations.terms("terms", "userName");
    }

    protected void index(int priority, String userName) {
        this.addDocument(document -> {
            document.addKeyword("userName", userName);
            document.addNumber("priority", priority);
        });
    }
}

