/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.Range;
import com.liferay.portal.search.aggregation.bucket.RangeAggregation;
import com.liferay.portal.search.aggregation.bucket.RangeAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseRangeAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testKeyedRanges() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        RangeAggregation rangeAggregation = this.getAggregation();
        rangeAggregation.addRange(new Range(11.0, null));
        rangeAggregation.addRange(new Range(0.0, 11.0));
        rangeAggregation.setKeyed(true);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(rangeAggregation));
            indexingTestHelper.search();
            RangeAggregationResult rangeAggregationResult = (RangeAggregationResult)indexingTestHelper.getAggregationResult(rangeAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(rangeAggregationResult.getBuckets());
            Assert.assertEquals("Num buckets", 2L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "0.0-11.0", 10L);
            this.assertBucket((Bucket)buckets.get(1), "11.0-*", 10L);
        });
    }

    @Test
    public void testRanges() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        RangeAggregation rangeAggregation = this.getAggregation();
        rangeAggregation.addRange(new Range("< 6", null, 6.0));
        rangeAggregation.addRange(new Range(">=6, <=10", 6.0, 11.0));
        rangeAggregation.addRange(new Range("> 10", 11.0, null));
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(rangeAggregation));
            indexingTestHelper.search();
            RangeAggregationResult rangeAggregationResult = (RangeAggregationResult)indexingTestHelper.getAggregationResult(rangeAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(rangeAggregationResult.getBuckets());
            Assert.assertEquals(((Object)buckets).toString(), 3L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "< 6", 5L);
            this.assertBucket((Bucket)buckets.get(1), ">=6, <=10", 5L);
            this.assertBucket((Bucket)buckets.get(2), "> 10", 10L);
        });
    }

    protected void assertBucket(Bucket bucket, String expectedKey, long expectedCount) {
        Assert.assertEquals(expectedKey, bucket.getKey());
        Assert.assertEquals(expectedCount, bucket.getDocCount());
    }

    protected RangeAggregation getAggregation() {
        return this.aggregations.range("range", "priority");
    }
}

