/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.bucket.MissingAggregation;
import com.liferay.portal.search.aggregation.bucket.MissingAggregationResult;
import com.liferay.portal.search.aggregation.metrics.SumAggregation;
import com.liferay.portal.search.aggregation.metrics.SumAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseMissingAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testMissing() throws Exception {
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 2);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 3);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 4);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 5);
        });
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 6.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 7.0));
        MissingAggregation missingAggregation = this.aggregations.missing("missing", "userName");
        SumAggregation sumAggregation = this.aggregations.sum("sum", "priority");
        missingAggregation.addChildAggregation(sumAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(missingAggregation));
            indexingTestHelper.search();
            MissingAggregationResult missingAggregationResult = (MissingAggregationResult)indexingTestHelper.getAggregationResult(missingAggregation);
            Assert.assertEquals("Documents missing user name", 2L, missingAggregationResult.getDocCount());
            SumAggregationResult sumAggregationResult = (SumAggregationResult)missingAggregationResult.getChildAggregationResult(sumAggregation.getName());
            Assert.assertEquals("SumUser1 total priorities", 13.0, sumAggregationResult.getValue(), 0.0);
        });
    }
}

