/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregation;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseHistogramAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testDateHistogramAggregationIntervalDay() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        HistogramAggregation histogramAggregation = this.aggregations.histogram("histogram", "priority");
        histogramAggregation.setInterval(5.0);
        histogramAggregation.setMinDocCount(1L);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(histogramAggregation));
            indexingTestHelper.search();
            HistogramAggregationResult histogramAggregationResult = (HistogramAggregationResult)indexingTestHelper.getAggregationResult(histogramAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(histogramAggregationResult.getBuckets());
            Assert.assertEquals("Number of buckets", 5L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "0.0", 4L);
            this.assertBucket((Bucket)buckets.get(1), "5.0", 5L);
            this.assertBucket((Bucket)buckets.get(2), "10.0", 5L);
            this.assertBucket((Bucket)buckets.get(3), "15.0", 5L);
            this.assertBucket((Bucket)buckets.get(4), "20.0", 1L);
        });
    }

    protected void assertBucket(Bucket bucket, String expectedKey, long expectedCount) {
        Assert.assertEquals(expectedKey, bucket.getKey());
        Assert.assertEquals(expectedCount, bucket.getDocCount());
    }
}

