/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.aggregation.bucket.GlobalAggregation;
import com.liferay.portal.search.aggregation.bucket.GlobalAggregationResult;
import com.liferay.portal.search.aggregation.metrics.AvgAggregation;
import com.liferay.portal.search.aggregation.metrics.AvgAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseGlobalAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testGlobalAggregation() throws Exception {
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 1);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 2);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 3);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 4);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 5);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 6);
        });
        this.addDocument(document -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 7);
        });
        GlobalAggregation globalAggregation = this.aggregations.global("global");
        AvgAggregation avgAggregation = this.aggregations.avg("avg", "priority");
        globalAggregation.addChildAggregation(avgAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(globalAggregation));
            indexingTestHelper.search();
            GlobalAggregationResult globalAggregationResult = (GlobalAggregationResult)indexingTestHelper.getAggregationResult(globalAggregation);
            Assert.assertEquals(7.0f, (float)globalAggregationResult.getDocCount(), 0.0f);
            Map<String, AggregationResult> childrenAggregationResults = globalAggregationResult.getChildrenAggregationResultsMap();
            Assert.assertEquals("Children aggregations", 1L, childrenAggregationResults.size());
            AvgAggregationResult avgAggregationResult = (AvgAggregationResult)globalAggregationResult.getChildAggregationResult("avg");
            Assert.assertEquals("Avg priority", 4.0, avgAggregationResult.getValue(), 0.0);
        });
    }
}

