/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.GeoDistanceAggregation;
import com.liferay.portal.search.aggregation.bucket.GeoDistanceAggregationResult;
import com.liferay.portal.search.aggregation.bucket.Range;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseGeoDistanceAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testGeoDistance() throws Exception {
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.374081, 4.91235));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.369219, 4.901618));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.369219, 4.901618));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 51.2229, 4.4052));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.861111, 2.336389));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.86, 2.327));
        GeoDistanceAggregation geoDistanceAggregation = this.aggregations.geoDistance("geo_distance", "geoLocation", this.geoBuilders.geoLocationPoint(52.376, 4.894));
        geoDistanceAggregation.addRange(new Range(null, 100000.0));
        geoDistanceAggregation.addRange(new Range(null, 100000.0, 300000.0));
        geoDistanceAggregation.addRange(new Range(300000.0, null));
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(geoDistanceAggregation));
            indexingTestHelper.search();
            GeoDistanceAggregationResult geoDistanceAggregationResult = (GeoDistanceAggregationResult)indexingTestHelper.getAggregationResult(geoDistanceAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(geoDistanceAggregationResult.getBuckets());
            Assert.assertEquals(((Object)buckets).toString(), 3L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "*-100000.0", 3L);
            this.assertBucket((Bucket)buckets.get(1), "100000.0-300000.0", 1L);
            this.assertBucket((Bucket)buckets.get(2), "300000.0-*", 2L);
        });
    }

    protected void assertBucket(Bucket bucket, String expectedKey, long expectedCount) {
        Assert.assertEquals(expectedKey, bucket.getKey());
        Assert.assertEquals(expectedCount, bucket.getDocCount());
    }
}

