/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.BucketAggregationResult;
import com.liferay.portal.search.aggregation.bucket.FiltersAggregation;
import com.liferay.portal.search.aggregation.bucket.FiltersAggregationResult;
import com.liferay.portal.search.aggregation.metrics.SumAggregation;
import com.liferay.portal.search.aggregation.metrics.SumAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseFiltersAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testFilter() throws Exception {
        this.index("SomeUser1", 1);
        this.index("SomeUser1", 2);
        this.index("SomeUser1", 3);
        this.index("SomeUser2", 4);
        this.index("SomeUser2", 5);
        this.index("SomeUser2", 6);
        this.index("SomeUser2", 7);
        FiltersAggregation filtersAggregation = this.aggregations.filters("filter", "userName");
        filtersAggregation.addKeyedQuery("SomeUser1", this.queries.term("userName", "SomeUser1"));
        filtersAggregation.addKeyedQuery("SomeUser2", this.queries.term("userName", "SomeUser2"));
        SumAggregation sumAggregation = this.aggregations.sum("sum", "priority");
        filtersAggregation.addChildAggregation(sumAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(filtersAggregation));
            indexingTestHelper.search();
            FiltersAggregationResult filtersAggregationResult = (FiltersAggregationResult)indexingTestHelper.getAggregationResult(filtersAggregation);
            this.assertBucket("SomeUser1", 3, 6, filtersAggregationResult, sumAggregation, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper);
            this.assertBucket("SomeUser2", 4, 22, filtersAggregationResult, sumAggregation, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper);
            Collection<Bucket> buckets = filtersAggregationResult.getBuckets();
            Assert.assertEquals("Number of buckets", 2L, buckets.size());
        });
    }

    protected void assertBucket(String userName, int size, int sum, BucketAggregationResult bucketAggregationResult, SumAggregation sumAggregation, BaseIndexingTestCase.IndexingTestHelper indexingTestHelper) {
        Bucket bucket = bucketAggregationResult.getBucket(userName);
        Assert.assertEquals("bucket size", size, bucket.getDocCount());
        SumAggregationResult sumAggregationResult = (SumAggregationResult)indexingTestHelper.getChildAggregationResult(bucket, (Aggregation)sumAggregation);
        Assert.assertEquals("sum of priorities of " + userName, (double)sum, sumAggregationResult.getValue(), 0.0);
    }

    protected void index(String userName, int priority) {
        this.addDocument(document -> {
            document.addKeyword("userName", userName);
            document.addNumber("priority", priority);
        });
    }
}

