/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.FilterAggregation;
import com.liferay.portal.search.aggregation.bucket.FilterAggregationResult;
import com.liferay.portal.search.aggregation.metrics.SumAggregation;
import com.liferay.portal.search.aggregation.metrics.SumAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseFilterAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testFilter() {
        this.index("SomeUser1", 1);
        this.index("SomeUser1", 2);
        this.index("SomeUser1", 3);
        this.index("SomeUser2", 4);
        this.index("SomeUser2", 5);
        this.index("SomeUser2", 6);
        this.index("SomeUser2", 7);
        FilterAggregation filterAggregation = this.aggregations.filter("filter", this.queries.term("userName", "SomeUser1"));
        SumAggregation sumAggregation = this.aggregations.sum("sum", "priority");
        filterAggregation.addChildAggregation(sumAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(filterAggregation));
            indexingTestHelper.search();
            FilterAggregationResult filterAggregationResult = (FilterAggregationResult)indexingTestHelper.getAggregationResult(filterAggregation);
            Assert.assertEquals("Filtered aggregation results", 3L, filterAggregationResult.getDocCount());
            SumAggregationResult sumAggregationResult = (SumAggregationResult)indexingTestHelper.getChildAggregationResult(filterAggregationResult, (Aggregation)sumAggregation);
            Assert.assertEquals("Sum of priority in results", 6.0, sumAggregationResult.getValue(), 0.0);
        });
    }

    protected void index(String userName, int priority) {
        this.addDocument(document -> {
            document.addKeyword("userName", userName);
            document.addNumber("priority", priority);
        });
    }
}

