/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.DateHistogramAggregation;
import com.liferay.portal.search.aggregation.bucket.DateHistogramAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseDateHistogramAggregationTestCase
extends BaseIndexingTestCase {
    private static final String _FIELD = "expirationDate";

    @Test
    public void testDateHistogramAggregationIntervalDay() throws Exception {
        this.addDocument(this.getDate("2017-02-01T00:00:00"));
        this.addDocument(this.getDate("2017-02-02T00:00:00"));
        this.addDocument(this.getDate("2017-02-02T00:00:00"));
        this.addDocument(this.getDate("2017-02-03T00:00:00"));
        this.addDocument(this.getDate("2017-02-03T00:00:00"));
        this.addDocument(this.getDate("2017-02-03T00:00:00"));
        this.addDocument(this.getDate("2017-02-05T00:00:00"));
        DateHistogramAggregation dateHistogramAggregation = this.getAggregation("1d");
        dateHistogramAggregation.setMinDocCount(1L);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(dateHistogramAggregation));
            indexingTestHelper.search();
            DateHistogramAggregationResult dateHistogramAggregationResult = (DateHistogramAggregationResult)indexingTestHelper.getAggregationResult(dateHistogramAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(dateHistogramAggregationResult.getBuckets());
            Assert.assertEquals(((Object)buckets).toString(), 4L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "20170201000000", 1L);
            this.assertBucket((Bucket)buckets.get(1), "20170202000000", 2L);
            this.assertBucket((Bucket)buckets.get(2), "20170203000000", 3L);
            this.assertBucket((Bucket)buckets.get(3), "20170205000000", 1L);
        });
    }

    @Test
    public void testDateHistogramAggregationIntervalHour() throws Exception {
        this.addDocument(this.getDate("2017-02-01T09:02:00"));
        this.addDocument(this.getDate("2017-02-01T09:35:00"));
        this.addDocument(this.getDate("2017-02-01T10:15:00"));
        this.addDocument(this.getDate("2017-02-01T13:06:00"));
        this.addDocument(this.getDate("2017-02-01T14:04:00"));
        this.addDocument(this.getDate("2017-02-01T14:05:00"));
        this.addDocument(this.getDate("2017-02-01T15:59:00"));
        this.addDocument(this.getDate("2017-02-01T16:06:00"));
        this.addDocument(this.getDate("2017-02-01T16:48:00"));
        this.addDocument(this.getDate("2017-02-01T16:59:00"));
        DateHistogramAggregation dateHistogramAggregation = this.getAggregation("1h");
        dateHistogramAggregation.setMinDocCount(1L);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(dateHistogramAggregation));
            indexingTestHelper.search();
            DateHistogramAggregationResult dateHistogramAggregationResult = (DateHistogramAggregationResult)indexingTestHelper.getAggregationResult(dateHistogramAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(dateHistogramAggregationResult.getBuckets());
            Assert.assertEquals(((Object)buckets).toString(), 6L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "20170201090000", 2L);
            this.assertBucket((Bucket)buckets.get(1), "20170201100000", 1L);
            this.assertBucket((Bucket)buckets.get(2), "20170201130000", 1L);
            this.assertBucket((Bucket)buckets.get(3), "20170201140000", 2L);
            this.assertBucket((Bucket)buckets.get(4), "20170201150000", 1L);
            this.assertBucket((Bucket)buckets.get(5), "20170201160000", 3L);
        });
    }

    @Test
    public void testDateHistogramAggregationIntervalMinute() throws Exception {
        this.addDocument(this.getDate("2017-02-01T09:02:35"));
        this.addDocument(this.getDate("2017-02-01T09:02:59"));
        this.addDocument(this.getDate("2017-02-01T09:15:37"));
        this.addDocument(this.getDate("2017-02-01T09:16:04"));
        this.addDocument(this.getDate("2017-02-01T09:16:42"));
        DateHistogramAggregation dateHistogramAggregation = this.getAggregation("1m");
        dateHistogramAggregation.setMinDocCount(1L);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(dateHistogramAggregation));
            indexingTestHelper.search();
            DateHistogramAggregationResult dateHistogramAggregationResult = (DateHistogramAggregationResult)indexingTestHelper.getAggregationResult(dateHistogramAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(dateHistogramAggregationResult.getBuckets());
            Assert.assertEquals(((Object)buckets).toString(), 3L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "20170201090200", 2L);
            this.assertBucket((Bucket)buckets.get(1), "20170201091500", 1L);
            this.assertBucket((Bucket)buckets.get(2), "20170201091600", 2L);
        });
    }

    @Test
    public void testDateHistogramAggregationIntervalMonth() throws Exception {
        this.addDocument(this.getDate("2017-01-01T00:00:00"));
        this.addDocument(this.getDate("2017-02-02T00:00:00"));
        this.addDocument(this.getDate("2017-02-03T00:00:00"));
        this.addDocument(this.getDate("2017-03-04T00:00:00"));
        this.addDocument(this.getDate("2017-03-05T00:00:00"));
        this.addDocument(this.getDate("2017-03-06T00:00:00"));
        DateHistogramAggregation dateHistogramAggregation = this.getAggregation("1M");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(dateHistogramAggregation));
            indexingTestHelper.search();
            DateHistogramAggregationResult dateHistogramAggregationResult = (DateHistogramAggregationResult)indexingTestHelper.getAggregationResult(dateHistogramAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(dateHistogramAggregationResult.getBuckets());
            Assert.assertEquals(((Object)buckets).toString(), 3L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "20170101000000", 1L);
            this.assertBucket((Bucket)buckets.get(1), "20170201000000", 2L);
            this.assertBucket((Bucket)buckets.get(2), "20170301000000", 3L);
        });
    }

    @Test
    public void testDateHistogramAggregationIntervalSecond() throws Exception {
        this.addDocument(this.getDate("2017-02-01T00:00:05"));
        this.addDocument(this.getDate("2017-02-01T00:00:11"));
        this.addDocument(this.getDate("2017-02-01T00:00:11"));
        this.addDocument(this.getDate("2017-02-01T00:00:37"));
        this.addDocument(this.getDate("2017-02-01T00:00:37"));
        this.addDocument(this.getDate("2017-02-01T00:00:37"));
        DateHistogramAggregation dateHistogramAggregation = this.getAggregation("1s");
        dateHistogramAggregation.setMinDocCount(1L);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(dateHistogramAggregation));
            indexingTestHelper.search();
            DateHistogramAggregationResult dateHistogramAggregationResult = (DateHistogramAggregationResult)indexingTestHelper.getAggregationResult(dateHistogramAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(dateHistogramAggregationResult.getBuckets());
            Assert.assertEquals(((Object)buckets).toString(), 3L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "20170201000005", 1L);
            this.assertBucket((Bucket)buckets.get(1), "20170201000011", 2L);
            this.assertBucket((Bucket)buckets.get(2), "20170201000037", 3L);
        });
    }

    @Test
    public void testDateHistogramAggregationIntervalYear() throws Exception {
        this.addDocument(this.getDate("2015-01-01T00:00:00"));
        this.addDocument(this.getDate("2015-06-24T00:00:00"));
        this.addDocument(this.getDate("2015-11-13T00:00:00"));
        this.addDocument(this.getDate("2016-03-04T00:00:00"));
        this.addDocument(this.getDate("2017-12-31T00:00:00"));
        DateHistogramAggregation dateHistogramAggregation = this.getAggregation("1y");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(dateHistogramAggregation));
            indexingTestHelper.search();
            DateHistogramAggregationResult dateHistogramAggregationResult = (DateHistogramAggregationResult)indexingTestHelper.getAggregationResult(dateHistogramAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(dateHistogramAggregationResult.getBuckets());
            Assert.assertEquals(((Object)buckets).toString(), 3L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "20150101000000", 3L);
            this.assertBucket((Bucket)buckets.get(1), "20160101000000", 1L);
            this.assertBucket((Bucket)buckets.get(2), "20170101000000", 1L);
        });
    }

    @Test
    public void testDateHistogramAggregationMinDocCount() throws Exception {
        this.addDocument(this.getDate("2017-02-01T00:00:05"));
        this.addDocument(this.getDate("2017-02-01T00:00:11"));
        this.addDocument(this.getDate("2017-02-01T00:00:11"));
        this.addDocument(this.getDate("2017-02-01T00:00:13"));
        this.addDocument(this.getDate("2017-02-01T00:00:21"));
        DateHistogramAggregation dateHistogramAggregation = this.getAggregation("5s");
        dateHistogramAggregation.setMinDocCount(0L);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(dateHistogramAggregation));
            indexingTestHelper.search();
            DateHistogramAggregationResult dateHistogramAggregationResult = (DateHistogramAggregationResult)indexingTestHelper.getAggregationResult(dateHistogramAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(dateHistogramAggregationResult.getBuckets());
            Assert.assertEquals(((Object)buckets).toString(), 4L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "20170201000005", 1L);
            this.assertBucket((Bucket)buckets.get(1), "20170201000010", 3L);
            this.assertBucket((Bucket)buckets.get(2), "20170201000015", 0L);
            this.assertBucket((Bucket)buckets.get(3), "20170201000020", 1L);
        });
    }

    @Test
    public void testDateHistogramAggregationOffset() throws Exception {
        this.addDocument(this.getDate("2018-02-01T00:00:00"));
        this.addDocument(this.getDate("2018-02-03T00:00:00"));
        this.addDocument(this.getDate("2018-02-05T00:00:00"));
        this.addDocument(this.getDate("2018-02-07T00:00:00"));
        this.addDocument(this.getDate("2018-02-09T00:00:00"));
        this.addDocument(this.getDate("2018-02-11T00:00:00"));
        this.addDocument(this.getDate("2018-02-13T00:00:00"));
        DateHistogramAggregation dateHistogramAggregation = this.getAggregation("1w");
        dateHistogramAggregation.setOffset(-86400000L);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation(dateHistogramAggregation));
            indexingTestHelper.search();
            DateHistogramAggregationResult dateHistogramAggregationResult = (DateHistogramAggregationResult)indexingTestHelper.getAggregationResult(dateHistogramAggregation);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(dateHistogramAggregationResult.getBuckets());
            Assert.assertEquals(((Object)buckets).toString(), 3L, buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "20180128000000", 2L);
            this.assertBucket((Bucket)buckets.get(1), "20180204000000", 3L);
            this.assertBucket((Bucket)buckets.get(2), "20180211000000", 2L);
        });
    }

    protected void addDocument(Date date) throws Exception {
        this.addDocument(DocumentCreationHelpers.singleDate(_FIELD, date));
    }

    protected void assertBucket(Bucket bucket, String expectedKey, long expectedCount) {
        Assert.assertEquals(expectedKey, bucket.getKey());
        Assert.assertEquals(expectedCount, bucket.getDocCount());
    }

    protected DateHistogramAggregation getAggregation(String dateHistogramInterval) {
        DateHistogramAggregation dateHistogramAggregation = this.aggregations.dateHistogram("date_histogram", _FIELD);
        dateHistogramAggregation.setDateHistogramInterval(dateHistogramInterval);
        return dateHistogramAggregation;
    }

    protected Date getDate(String date) {
        LocalDateTime localDateTime = LocalDateTime.parse(date);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }
}

