/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.util.test.LayoutTestUtil;
import java.util.Collections;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.portlet.MockPortletResponse;
import org.springframework.mock.web.portlet.MockRenderRequest;

public class SummaryFixture<T> {
    private final Class<T> _class;
    private final Locale _defaultLocale;
    private final Group _group;
    private final Indexer<T> _indexer;
    private final User _user;

    public SummaryFixture(Class<T> clazz, Group group, Locale defaultLocale, User user) {
        this._class = clazz;
        this._indexer = IndexerRegistryUtil.getIndexer(clazz);
        this._group = group;
        this._defaultLocale = defaultLocale;
        this._user = user;
    }

    public void assertSummary(String title, String content, Document document) throws Exception {
        this.assertSummary(title, content, this._defaultLocale, document);
    }

    public void assertSummary(String title, String content, Locale locale, Document document) throws Exception {
        Assert.assertEquals(this._class.getName(), document.get("entryClassName"));
        Summary summary = this.getSummary(document, locale);
        Assert.assertEquals(content, summary.getContent());
        Assert.assertEquals(title, summary.getTitle());
    }

    public Summary getSummary(Document document, Locale locale) throws Exception {
        return this._indexer.getSummary(document, document.get("snippet"), this.createPortletRequest(locale), this.createPortletResponse());
    }

    protected HttpServletRequest createHttpServletRequest(PortletRequest portletRequest, Locale locale) {
        MockHttpServletRequest mockHttpServletRequest = new MockHttpServletRequest();
        mockHttpServletRequest.setAttribute("javax.portlet.request", portletRequest);
        mockHttpServletRequest.setPreferredLocales(Collections.singletonList(locale));
        return mockHttpServletRequest;
    }

    protected HttpServletResponse createHttpServletResponse() {
        return new MockHttpServletResponse();
    }

    protected PortletRequest createPortletRequest(Locale locale) throws Exception {
        MockRenderRequest mockRenderRequest = new MockRenderRequest();
        HttpServletRequest httpServletRequest = this.createHttpServletRequest(mockRenderRequest, locale);
        HttpServletResponse httpServletResponse = this.createHttpServletResponse();
        ThemeDisplay themeDisplay = this.createThemeDisplay(httpServletRequest, httpServletResponse, locale);
        mockRenderRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", themeDisplay);
        mockRenderRequest.addPreferredLocale(locale);
        httpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        return mockRenderRequest;
    }

    protected PortletResponse createPortletResponse() {
        return new MockPortletResponse();
    }

    protected ThemeDisplay createThemeDisplay(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) throws Exception {
        ThemeDisplay themeDisplay = new ThemeDisplay();
        themeDisplay.setCompany(CompanyLocalServiceUtil.getCompany(this._group.getCompanyId()));
        themeDisplay.setLayout(LayoutTestUtil.addLayout(this._group));
        LayoutSet layoutSet = this._group.getPublicLayoutSet();
        themeDisplay.setLayoutSet(layoutSet);
        themeDisplay.setLocale(locale);
        Theme theme = ThemeLocalServiceUtil.getTheme(this._group.getCompanyId(), layoutSet.getThemeId());
        themeDisplay.setLookAndFeel(theme, null);
        themeDisplay.setRealUser(this._user);
        themeDisplay.setRequest(httpServletRequest);
        themeDisplay.setResponse(httpServletResponse);
        themeDisplay.setTimeZone(TimeZoneUtil.getDefault());
        themeDisplay.setUser(this._user);
        return themeDisplay;
    }
}

