/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.result.SearchResultTranslator;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import java.util.List;

public class SearchTestUtil {
    public static final String ATTACHMENT_OWNER_CLASS_NAME = RandomTestUtil.randomString(new RandomizerBumper[0]);
    public static final long ATTACHMENT_OWNER_CLASS_NAME_ID = RandomTestUtil.randomLong();
    public static final long ATTACHMENT_OWNER_CLASS_PK = RandomTestUtil.randomLong();
    public static final long ENTRY_CLASS_PK = RandomTestUtil.randomLong();
    public static final String SUMMARY_CONTENT = RandomTestUtil.randomString(new RandomizerBumper[0]);
    public static final String SUMMARY_TITLE = RandomTestUtil.randomString(new RandomizerBumper[0]);

    public static Document createAttachmentDocument(String entryClassName) {
        return SearchTestUtil.createAttachmentDocument(entryClassName, ENTRY_CLASS_PK);
    }

    public static Document createAttachmentDocument(String entryClassName, long entryClassPK) {
        Document document = SearchTestUtil.createDocument(entryClassName, entryClassPK);
        DocumentHelper documentHelper = new DocumentHelper(document);
        documentHelper.setAttachmentOwnerKey(ATTACHMENT_OWNER_CLASS_NAME_ID, ATTACHMENT_OWNER_CLASS_PK);
        return document;
    }

    public static Document createDocument(String entryClassName) {
        return SearchTestUtil.createDocument(entryClassName, ENTRY_CLASS_PK);
    }

    public static Document createDocument(String entryClassName, long entryClassPK) {
        DocumentImpl document = new DocumentImpl();
        DocumentHelper documentHelper = new DocumentHelper(document);
        documentHelper.setEntryKey(entryClassName, entryClassPK);
        return document;
    }

    public static List<SearchResult> getSearchResults(SearchResultTranslator searchResultTranslator, Document ... documents) {
        HitsImpl hits = new HitsImpl();
        hits.setDocs(documents);
        return searchResultTranslator.translate(hits, null, null, null);
    }
}

