/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.search.test.util.AssertUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FieldValuesAssert {
    public static void assertFieldValues(Map<String, String> expected, Document document, String message) {
        AssertUtils.assertEquals(message, expected, FieldValuesAssert._getFieldValues(document, null));
    }

    public static void assertFieldValues(Map<String, String> expected, String prefix, Document document, String message) {
        AssertUtils.assertEquals(message, expected, FieldValuesAssert._getFieldValues(document, name -> name.startsWith(prefix)));
    }

    private static Map<String, String> _getFieldValues(Document document, Predicate<String> predicate) {
        Map<String, Field> fieldsMap = document.getFields();
        Set<Map.Entry<String, Field>> entrySet = fieldsMap.entrySet();
        Stream<Object> stream = entrySet.stream();
        if (predicate != null) {
            stream = stream.filter(entry -> predicate.test((String)entry.getKey()));
        }
        return stream.collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Field field = (Field)entry.getValue();
            String[] values = field.getValues();
            if (values == null) {
                return null;
            }
            if (values.length == 1) {
                return values[0];
            }
            return String.valueOf(Arrays.asList(values));
        }));
    }
}

