/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.search.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;

public class DocumentsAssert {
    public static void assertCount(String message, Document[] documents, String fieldName, int expectedCount) {
        if (documents.length == expectedCount) {
            return;
        }
        List<String> actualValues = DocumentsAssert._getFieldValueStrings(fieldName, documents);
        Assert.assertEquals(message + "->" + actualValues, expectedCount, documents.length);
    }

    public static void assertValues(String message, Document[] documents, String fieldName, List<String> expectedValues) {
        DocumentsAssert.assertValues(message, documents, fieldName, String.valueOf(expectedValues));
    }

    public static void assertValues(String message, Document[] documents, String fieldName, String expected) {
        List<String> actualValues = DocumentsAssert._getFieldValueStrings(fieldName, documents);
        Assert.assertEquals(message + "->" + actualValues, expected, String.valueOf(actualValues));
    }

    public static void assertValues(String message, Stream<com.liferay.portal.search.document.Document> documents, String fieldName, String expected) {
        List<String> actualValues = DocumentsAssert._getFieldValueStrings(fieldName, documents);
        Assert.assertEquals(message + "->" + actualValues, expected, String.valueOf(actualValues));
    }

    public static void assertValuesIgnoreRelevance(String message, Document[] documents, String fieldName, Collection<String> expectedValues) {
        List<String> actualValues = DocumentsAssert._getFieldValueStrings(fieldName, documents);
        Assert.assertEquals(message + "->" + actualValues, DocumentsAssert._sort(expectedValues), DocumentsAssert._sort(actualValues));
    }

    public static void assertValuesIgnoreRelevance(String message, Stream<com.liferay.portal.search.document.Document> documents, String fieldName, String expected) {
        List<String> actualValues = DocumentsAssert._getFieldValueStrings(fieldName, documents);
        Assert.assertEquals(message + "->" + actualValues, expected, DocumentsAssert._sort(actualValues));
    }

    private static List<Object> _getFieldValues(String fieldName, Document document) {
        return Arrays.asList((Object[])document.getValues(fieldName));
    }

    private static String _getFieldValueString(List<Object> fieldValues) {
        if (fieldValues.isEmpty()) {
            return "";
        }
        if (fieldValues.size() == 1) {
            return String.valueOf(fieldValues.get(0));
        }
        return String.valueOf(fieldValues);
    }

    private static List<String> _getFieldValueStrings(Stream<List<Object>> stream) {
        return stream.map(DocumentsAssert::_getFieldValueString).collect(Collectors.toList());
    }

    private static List<String> _getFieldValueStrings(String fieldName, Document ... documents) {
        Stream<Document> stream = Stream.of(documents);
        return DocumentsAssert._getFieldValueStrings(stream.map(document -> DocumentsAssert._getFieldValues(fieldName, document)));
    }

    private static List<String> _getFieldValueStrings(String fieldName, Stream<com.liferay.portal.search.document.Document> stream) {
        return DocumentsAssert._getFieldValueStrings(stream.map(document -> document.getValues(fieldName)));
    }

    private static String _sort(Collection<String> collection) {
        ArrayList<String> list = new ArrayList<String>(collection);
        Collections.sort(list);
        return ((Object)list).toString();
    }
}

