/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ClassNameWrapper;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.RelatedSearchResult;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.result.SearchResultTranslator;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ClassNameLocalServiceWrapper;
import com.liferay.portal.kernel.test.util.PropsTestUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.search.test.util.SearchTestUtil;
import com.liferay.registry.BasicRegistryImpl;
import com.liferay.registry.RegistryUtil;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;

public abstract class BaseSearchResultUtilTestCase {
    protected ClassNameLocalService classNameLocalService;
    protected SearchResultTranslator searchResultTranslator;

    @Before
    public void setUp() throws Exception {
        this.setUpRegistryUtil();
        this.setUpClassNameLocalService();
        this.setUpFastDateFormatFactoryUtil();
        this.setUpPropsUtil();
        this.setUpSearchResultTranslator();
    }

    protected void assertEmptyCommentRelatedSearchResults(SearchResult searchResult) {
        List<RelatedSearchResult<Comment>> commentRelatedSearchResults = searchResult.getCommentRelatedSearchResults();
        Assert.assertTrue(commentRelatedSearchResults.toString(), commentRelatedSearchResults.isEmpty());
    }

    protected void assertEmptyFileEntryRelatedSearchResults(SearchResult searchResult) {
        List<RelatedSearchResult<FileEntry>> fileEntryRelatedSearchResults = searchResult.getFileEntryRelatedSearchResults();
        Assert.assertTrue(fileEntryRelatedSearchResults.toString(), fileEntryRelatedSearchResults.isEmpty());
    }

    protected void assertEmptyVersions(SearchResult searchResult) {
        List<String> versions = searchResult.getVersions();
        Assert.assertTrue(versions.toString(), versions.isEmpty());
    }

    protected SearchResult assertOneSearchResult(Document document) {
        List<SearchResult> searchResults = SearchTestUtil.getSearchResults(this.searchResultTranslator, document);
        Assert.assertEquals(searchResults.toString(), 1L, searchResults.size());
        return searchResults.get(0);
    }

    protected abstract SearchResultTranslator createSearchResultTranslator();

    protected void setUpClassNameLocalService() {
        this.classNameLocalService = new ClassNameLocalServiceWrapper(null){

            @Override
            public ClassName getClassName(long classNameId) {
                if (classNameId == SearchTestUtil.ATTACHMENT_OWNER_CLASS_NAME_ID) {
                    return new ClassNameWrapper(null){

                        @Override
                        public String getClassName() {
                            return SearchTestUtil.ATTACHMENT_OWNER_CLASS_NAME;
                        }
                    };
                }
                return null;
            }
        };
    }

    protected void setUpFastDateFormatFactoryUtil() {
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory(ProxyFactory.newDummyInstance(FastDateFormatFactory.class));
    }

    protected void setUpPropsUtil() {
        PropsTestUtil.setProps(Collections.emptyMap());
    }

    protected void setUpRegistryUtil() {
        RegistryUtil.setRegistry(new BasicRegistryImpl());
    }

    protected void setUpSearchResultTranslator() {
        this.searchResultTranslator = this.createSearchResultTranslator();
    }
}

