/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class AssertUtils {
    public static void assertEquals(String message, JSONObject expectedJSONObject, JSONObject actualJSONObject) {
        String actual = AssertUtils._toString(actualJSONObject);
        Assert.assertEquals(message, AssertUtils._toString(expectedJSONObject), actual);
    }

    public static void assertEquals(String message, List<?> expectedList, List<?> actualList) {
        Assert.assertEquals(message, expectedList.toString(), actualList.toString());
    }

    public static void assertEquals(String message, Map<?, ?> expectedMap, Map<?, ?> actualMap) {
        String actual = AssertUtils._toString(actualMap);
        Assert.assertEquals(message + "->" + actual, AssertUtils._toString(expectedMap), actual);
    }

    private static String _toString(JSONArray jsonArray) {
        ArrayList list = new ArrayList(jsonArray.length());
        jsonArray.forEach(value -> list.add(AssertUtils._toString(value)));
        Collections.sort(list);
        return "[" + StringUtil.merge(list, ",") + "]";
    }

    private static String _toString(JSONObject jsonObject) {
        ArrayList list = new ArrayList(jsonObject.length());
        Iterator<String> keys = jsonObject.keys();
        keys.forEachRemaining(key -> list.add(AssertUtils._toString(key) + ":" + AssertUtils._toString(jsonObject.get((String)key))));
        Collections.sort(list);
        return "{" + StringUtil.merge(list, ",") + "}";
    }

    private static String _toString(Map<?, ?> map) {
        ArrayList<String> list = new ArrayList<String>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            list.add(entry.toString());
        }
        Collections.sort(list);
        return ((Object)list).toString();
    }

    private static String _toString(Object object) {
        if (object instanceof JSONObject) {
            return AssertUtils._toString((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return AssertUtils._toString((JSONArray)object);
        }
        if (object instanceof String) {
            return AssertUtils._toString((String)object);
        }
        return object.toString();
    }

    private static String _toString(String string) {
        String escapedString = string.replace("\"", "\\\"");
        return "\"" + escapedString + "\"";
    }
}

