/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.buffer;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.search.buffer.IndexerRequest;
import com.liferay.portal.search.buffer.IndexerRequestBufferOverflowHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class IndexerRequestBuffer {
    private static final ThreadLocal<List<IndexerRequestBuffer>> _indexerRequestBuffersThreadLocal = new CentralizedThreadLocal<List>(IndexerRequestBuffer.class + "._indexerRequestBuffersThreadLocal", ArrayList::new);
    private final LinkedHashMap<IndexerRequest, IndexerRequest> _indexerRequests = new LinkedHashMap();

    public static IndexerRequestBuffer create() {
        List<IndexerRequestBuffer> indexerRequestBuffers = _indexerRequestBuffersThreadLocal.get();
        IndexerRequestBuffer indexerRequestBuffer = new IndexerRequestBuffer();
        indexerRequestBuffers.add(indexerRequestBuffer);
        return indexerRequestBuffer;
    }

    public static IndexerRequestBuffer get() {
        List<IndexerRequestBuffer> indexerRequestBuffers = _indexerRequestBuffersThreadLocal.get();
        if (indexerRequestBuffers.isEmpty()) {
            return null;
        }
        return indexerRequestBuffers.get(indexerRequestBuffers.size() - 1);
    }

    public static IndexerRequestBuffer remove() {
        List<IndexerRequestBuffer> indexerRequestBuffers = _indexerRequestBuffersThreadLocal.get();
        if (indexerRequestBuffers.isEmpty()) {
            return null;
        }
        return indexerRequestBuffers.remove(indexerRequestBuffers.size() - 1);
    }

    @Deprecated
    public void add(IndexerRequest indexerRequest) {
        this._indexerRequests.put(indexerRequest, indexerRequest);
    }

    public void add(IndexerRequest indexerRequest, IndexerRequestBufferOverflowHandler indexerRequestBufferOverflowHandler, int maxBufferSize) {
        this._indexerRequests.put(indexerRequest, indexerRequest);
        indexerRequestBufferOverflowHandler.bufferOverflowed(this, maxBufferSize);
    }

    public void clear() {
        this._indexerRequests.clear();
    }

    public Collection<IndexerRequest> getIndexerRequests() {
        return this._indexerRequests.values();
    }

    public boolean isEmpty() {
        return this._indexerRequests.isEmpty();
    }

    public void remove(IndexerRequest indexerRequest) {
        this._indexerRequests.remove(indexerRequest);
    }

    public int size() {
        return this._indexerRequests.size();
    }
}

