/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.aggregation.bucket;

import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class Range {
    private final Double _from;
    private final String _fromAsString;
    private String _key;
    private final Double _to;
    private final String _toAsString;

    public static Range unboundedFrom(Double from) {
        return new Range(from, null);
    }

    public static Range unboundedFrom(String key, Double from) {
        return new Range(key, from, null);
    }

    public static Range unboundedTo(Double to) {
        return new Range(null, to);
    }

    public static Range unboundedTo(String key, Double to) {
        return new Range(key, null, to);
    }

    public Range(Double from, Double to) {
        this._from = from;
        this._fromAsString = null;
        this._to = to;
        this._toAsString = null;
    }

    public Range(String key, Double from, Double to) {
        this._key = key;
        this._from = from;
        this._fromAsString = null;
        this._to = to;
        this._toAsString = null;
    }

    public Range(String from, String to) {
        this._from = null;
        this._fromAsString = from;
        this._to = null;
        this._toAsString = to;
    }

    public Range(String key, String from, String to) {
        this._key = key;
        this._from = null;
        this._fromAsString = from;
        this._to = null;
        this._toAsString = to;
    }

    public Double getFrom() {
        return this._from;
    }

    public String getFromAsString() {
        return this._fromAsString;
    }

    public String getKey() {
        return this._key;
    }

    public Double getTo() {
        return this._to;
    }

    public String getToAsString() {
        return this._toAsString;
    }
}

